@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The description of the IoT hub.
 * @property etag The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
 * @property id The resource identifier.
 * @property identity The managed identities for the IotHub.
 * @property location The resource location.
 * @property name The resource name.
 * @property properties IotHub properties
 * @property sku IotHub SKU info
 * @property systemData The system meta data relating to this resource.
 * @property tags The resource tags.
 * @property type The resource type.
 */
public data class GetIotHubResourceResult(
    public val etag: String? = null,
    public val id: String,
    public val identity: ArmIdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val properties: IotHubPropertiesResponse,
    public val sku: IotHubSkuInfoResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.GetIotHubResourceResult):
            GetIotHubResourceResult = GetIotHubResourceResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.ArmIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.devices.kotlin.outputs.IotHubPropertiesResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.devices.kotlin.outputs.IotHubSkuInfoResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
