@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The private endpoint connection of an IotHub
 * @property id The resource identifier.
 * @property name The resource name.
 * @property properties The properties of a private endpoint connection
 * @property type The resource type.
 */
public data class GetPrivateEndpointConnectionResult(
    public val id: String,
    public val name: String,
    public val properties: PrivateEndpointConnectionPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.GetPrivateEndpointConnectionResult):
            GetPrivateEndpointConnectionResult = GetPrivateEndpointConnectionResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.devices.kotlin.outputs.PrivateEndpointConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
