@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * the service specific properties of a provisioning service, including keys, linked iot hubs, current state, and system generated properties such as hostname and idScope
 * @property allocationPolicy Allocation policy to be used by this provisioning service.
 * @property authorizationPolicies List of authorization keys for a provisioning service.
 * @property deviceProvisioningHostName Device endpoint for this provisioning service.
 * @property enableDataResidency Optional.
 * Indicates if the DPS instance has Data Residency enabled, removing the cross geo-pair disaster recovery.
 * @property idScope Unique identifier of this provisioning service.
 * @property iotHubs List of IoT hubs associated with this provisioning service.
 * @property ipFilterRules The IP filter rules.
 * @property portalOperationsHostName Portal endpoint to enable CORS for this provisioning service.
 * @property privateEndpointConnections Private endpoint connections created on this IotHub
 * @property provisioningState The ARM provisioning state of the provisioning service.
 * @property publicNetworkAccess Whether requests from Public Network are allowed
 * @property serviceOperationsHostName Service endpoint for provisioning service.
 * @property state Current state of the provisioning service.
 */
public data class IotDpsPropertiesDescriptionResponse(
    public val allocationPolicy: String? = null,
    public val authorizationPolicies:
    List<SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse>? = null,
    public val deviceProvisioningHostName: String,
    public val enableDataResidency: Boolean? = null,
    public val idScope: String,
    public val iotHubs: List<IotHubDefinitionDescriptionResponse>? = null,
    public val ipFilterRules: List<TargetIpFilterRuleResponse>? = null,
    public val portalOperationsHostName: String? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val provisioningState: String? = null,
    public val publicNetworkAccess: String? = null,
    public val serviceOperationsHostName: String,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.IotDpsPropertiesDescriptionResponse):
            IotDpsPropertiesDescriptionResponse = IotDpsPropertiesDescriptionResponse(
            allocationPolicy = javaType.allocationPolicy().map({ args0 -> args0 }).orElse(null),
            authorizationPolicies = javaType.authorizationPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse.Companion.toKotlin(args0)
                })
            }),
            deviceProvisioningHostName = javaType.deviceProvisioningHostName(),
            enableDataResidency = javaType.enableDataResidency().map({ args0 -> args0 }).orElse(null),
            idScope = javaType.idScope(),
            iotHubs = javaType.iotHubs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.IotHubDefinitionDescriptionResponse.Companion.toKotlin(args0)
                })
            }),
            ipFilterRules = javaType.ipFilterRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.TargetIpFilterRuleResponse.Companion.toKotlin(args0)
                })
            }),
            portalOperationsHostName = javaType.portalOperationsHostName().map({ args0 -> args0 }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            serviceOperationsHostName = javaType.serviceOperationsHostName(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
