@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Suppress

/**
 * The properties of a private endpoint connection
 * @property privateEndpoint The private endpoint property of a private endpoint connection
 * @property privateLinkServiceConnectionState The current state of a private endpoint connection
 */
public data class PrivateEndpointConnectionPropertiesResponse(
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.PrivateEndpointConnectionPropertiesResponse):
            PrivateEndpointConnectionPropertiesResponse = PrivateEndpointConnectionPropertiesResponse(
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().let({ args0 ->
                com.pulumi.azurenative.devices.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
