@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of an IoT hub shared access policy.
 * @property keyName The name of the shared access policy.
 * @property primaryKey The primary key.
 * @property rights The permissions assigned to the shared access policy.
 * @property secondaryKey The secondary key.
 */
public data class SharedAccessSignatureAuthorizationRuleResponse(
    public val keyName: String,
    public val primaryKey: String? = null,
    public val rights: String,
    public val secondaryKey: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.SharedAccessSignatureAuthorizationRuleResponse):
            SharedAccessSignatureAuthorizationRuleResponse =
            SharedAccessSignatureAuthorizationRuleResponse(
                keyName = javaType.keyName(),
                primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
                rights = javaType.rights(),
                secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
            )
    }
}
