@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the Azure Storage endpoint for file upload.
 * @property authenticationType Specifies authentication type being used for connecting to the storage account.
 * @property connectionString The connection string for the Azure Storage account to which files are uploaded.
 * @property containerName The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
 * @property identity Managed identity properties of storage endpoint for file upload.
 * @property sasTtlAsIso8601 The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
 */
public data class StorageEndpointPropertiesResponse(
    public val authenticationType: String? = null,
    public val connectionString: String,
    public val containerName: String,
    public val identity: ManagedIdentityResponse? = null,
    public val sasTtlAsIso8601: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.StorageEndpointPropertiesResponse):
            StorageEndpointPropertiesResponse = StorageEndpointPropertiesResponse(
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            connectionString = javaType.connectionString(),
            containerName = javaType.containerName(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sasTtlAsIso8601 = javaType.sasTtlAsIso8601().map({ args0 -> args0 }).orElse(null),
        )
    }
}
