@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin

import com.pulumi.azurenative.deviceupdate.kotlin.outputs.DiagnosticStoragePropertiesResponse
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.IotHubSettingsResponse
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.DiagnosticStoragePropertiesResponse.Companion.toKotlin as diagnosticStoragePropertiesResponseToKotlin
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.IotHubSettingsResponse.Companion.toKotlin as iotHubSettingsResponseToKotlin
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.azurenative.deviceupdate.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Device Update instance details.
 * Azure REST API version: 2023-07-01. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * ## Example Usage
 * ### Creates or updates Instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instance = new AzureNative.DeviceUpdate.Instance("instance", new()
 *     {
 *         AccountName = "contoso",
 *         DiagnosticStorageProperties = new AzureNative.DeviceUpdate.Inputs.DiagnosticStoragePropertiesArgs
 *         {
 *             AuthenticationType = "KeyBased",
 *             ConnectionString = "string",
 *             ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/adu-resource-group/providers/Microsoft.Storage/storageAccounts/testAccount",
 *         },
 *         EnableDiagnostics = false,
 *         InstanceName = "blue",
 *         IotHubs = new[]
 *         {
 *             new AzureNative.DeviceUpdate.Inputs.IotHubSettingsArgs
 *             {
 *                 ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Devices/IotHubs/blue-contoso-hub",
 *             },
 *         },
 *         Location = "westus2",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceupdate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceupdate.NewInstance(ctx, "instance", &deviceupdate.InstanceArgs{
 * 			AccountName: pulumi.String("contoso"),
 * 			DiagnosticStorageProperties: &deviceupdate.DiagnosticStoragePropertiesArgs{
 * 				AuthenticationType: pulumi.String("KeyBased"),
 * 				ConnectionString:   pulumi.String("string"),
 * 				ResourceId:         pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/adu-resource-group/providers/Microsoft.Storage/storageAccounts/testAccount"),
 * 			},
 * 			EnableDiagnostics: pulumi.Bool(false),
 * 			InstanceName:      pulumi.String("blue"),
 * 			IotHubs: []deviceupdate.IotHubSettingsArgs{
 * 				{
 * 					ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Devices/IotHubs/blue-contoso-hub"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus2"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceupdate.Instance;
 * import com.pulumi.azurenative.deviceupdate.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .accountName("contoso")
 *             .diagnosticStorageProperties(Map.ofEntries(
 *                 Map.entry("authenticationType", "KeyBased"),
 *                 Map.entry("connectionString", "string"),
 *                 Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/adu-resource-group/providers/Microsoft.Storage/storageAccounts/testAccount")
 *             ))
 *             .enableDiagnostics(false)
 *             .instanceName("blue")
 *             .iotHubs(Map.of("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Devices/IotHubs/blue-contoso-hub"))
 *             .location("westus2")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceupdate:Instance blue /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/instances/{instanceName}
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.azurenative.deviceupdate.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Parent Device Update Account name which Instance belongs to.
     */
    public val accountName: Output<String>
        get() = javaResource.accountName().applyValue({ args0 -> args0 })

    /**
     * Customer-initiated diagnostic log collection storage properties
     */
    public val diagnosticStorageProperties: Output<DiagnosticStoragePropertiesResponse>?
        get() = javaResource.diagnosticStorageProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> diagnosticStoragePropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Enables or Disables the diagnostic logs collection
     */
    public val enableDiagnostics: Output<Boolean>?
        get() = javaResource.enableDiagnostics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of IoT Hubs associated with the account.
     */
    public val iotHubs: Output<List<IotHubSettingsResponse>>?
        get() = javaResource.iotHubs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> iotHubSettingsResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.deviceupdate.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.azurenative.deviceupdate.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit):
    Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
