@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin

import com.pulumi.azurenative.deviceupdate.InstanceArgs.builder
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.DiagnosticStoragePropertiesArgs
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.DiagnosticStoragePropertiesArgsBuilder
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.IotHubSettingsArgs
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.IotHubSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Device Update instance details.
 * Azure REST API version: 2023-07-01. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * ## Example Usage
 * ### Creates or updates Instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instance = new AzureNative.DeviceUpdate.Instance("instance", new()
 *     {
 *         AccountName = "contoso",
 *         DiagnosticStorageProperties = new AzureNative.DeviceUpdate.Inputs.DiagnosticStoragePropertiesArgs
 *         {
 *             AuthenticationType = "KeyBased",
 *             ConnectionString = "string",
 *             ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/adu-resource-group/providers/Microsoft.Storage/storageAccounts/testAccount",
 *         },
 *         EnableDiagnostics = false,
 *         InstanceName = "blue",
 *         IotHubs = new[]
 *         {
 *             new AzureNative.DeviceUpdate.Inputs.IotHubSettingsArgs
 *             {
 *                 ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Devices/IotHubs/blue-contoso-hub",
 *             },
 *         },
 *         Location = "westus2",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceupdate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceupdate.NewInstance(ctx, "instance", &deviceupdate.InstanceArgs{
 * 			AccountName: pulumi.String("contoso"),
 * 			DiagnosticStorageProperties: &deviceupdate.DiagnosticStoragePropertiesArgs{
 * 				AuthenticationType: pulumi.String("KeyBased"),
 * 				ConnectionString:   pulumi.String("string"),
 * 				ResourceId:         pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/adu-resource-group/providers/Microsoft.Storage/storageAccounts/testAccount"),
 * 			},
 * 			EnableDiagnostics: pulumi.Bool(false),
 * 			InstanceName:      pulumi.String("blue"),
 * 			IotHubs: []deviceupdate.IotHubSettingsArgs{
 * 				{
 * 					ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Devices/IotHubs/blue-contoso-hub"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus2"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceupdate.Instance;
 * import com.pulumi.azurenative.deviceupdate.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .accountName("contoso")
 *             .diagnosticStorageProperties(Map.ofEntries(
 *                 Map.entry("authenticationType", "KeyBased"),
 *                 Map.entry("connectionString", "string"),
 *                 Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/adu-resource-group/providers/Microsoft.Storage/storageAccounts/testAccount")
 *             ))
 *             .enableDiagnostics(false)
 *             .instanceName("blue")
 *             .iotHubs(Map.of("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Devices/IotHubs/blue-contoso-hub"))
 *             .location("westus2")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceupdate:Instance blue /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/instances/{instanceName}
 * ```
 * @property accountName Account name.
 * @property diagnosticStorageProperties Customer-initiated diagnostic log collection storage properties
 * @property enableDiagnostics Enables or Disables the diagnostic logs collection
 * @property instanceName Instance name.
 * @property iotHubs List of IoT Hubs associated with the account.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The resource group name.
 * @property tags Resource tags.
 */
public data class InstanceArgs(
    public val accountName: Output<String>? = null,
    public val diagnosticStorageProperties: Output<DiagnosticStoragePropertiesArgs>? = null,
    public val enableDiagnostics: Output<Boolean>? = null,
    public val instanceName: Output<String>? = null,
    public val iotHubs: Output<List<IotHubSettingsArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.InstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.InstanceArgs =
        com.pulumi.azurenative.deviceupdate.InstanceArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .diagnosticStorageProperties(
                diagnosticStorageProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enableDiagnostics(enableDiagnostics?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .iotHubs(
                iotHubs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var diagnosticStorageProperties: Output<DiagnosticStoragePropertiesArgs>? = null

    private var enableDiagnostics: Output<Boolean>? = null

    private var instanceName: Output<String>? = null

    private var iotHubs: Output<List<IotHubSettingsArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Account name.
     */
    @JvmName("saufescqgjrxrjqk")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Customer-initiated diagnostic log collection storage properties
     */
    @JvmName("qgygbnwkgiqmojeo")
    public suspend fun diagnosticStorageProperties(`value`: Output<DiagnosticStoragePropertiesArgs>) {
        this.diagnosticStorageProperties = value
    }

    /**
     * @param value Enables or Disables the diagnostic logs collection
     */
    @JvmName("wbjsplmjhwfmspsf")
    public suspend fun enableDiagnostics(`value`: Output<Boolean>) {
        this.enableDiagnostics = value
    }

    /**
     * @param value Instance name.
     */
    @JvmName("jgbbikmnjkykdfgb")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value List of IoT Hubs associated with the account.
     */
    @JvmName("qccsnsiylnspicnv")
    public suspend fun iotHubs(`value`: Output<List<IotHubSettingsArgs>>) {
        this.iotHubs = value
    }

    @JvmName("sultnkmugeyuvfqt")
    public suspend fun iotHubs(vararg values: Output<IotHubSettingsArgs>) {
        this.iotHubs = Output.all(values.asList())
    }

    /**
     * @param values List of IoT Hubs associated with the account.
     */
    @JvmName("oxahvkmmbqdsnkan")
    public suspend fun iotHubs(values: List<Output<IotHubSettingsArgs>>) {
        this.iotHubs = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ommodfebaycysfdb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("msjibmhyujqpachv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lueqsjtltexpjdux")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Account name.
     */
    @JvmName("iliqwudyjbudhsko")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Customer-initiated diagnostic log collection storage properties
     */
    @JvmName("wruissvxtqdbfrdq")
    public suspend fun diagnosticStorageProperties(`value`: DiagnosticStoragePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticStorageProperties = mapped
    }

    /**
     * @param argument Customer-initiated diagnostic log collection storage properties
     */
    @JvmName("jufmmvtvcslegqas")
    public suspend
    fun diagnosticStorageProperties(argument: suspend DiagnosticStoragePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DiagnosticStoragePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnosticStorageProperties = mapped
    }

    /**
     * @param value Enables or Disables the diagnostic logs collection
     */
    @JvmName("ksdepconyfqleuvt")
    public suspend fun enableDiagnostics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDiagnostics = mapped
    }

    /**
     * @param value Instance name.
     */
    @JvmName("mkvebuwqscaswivm")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value List of IoT Hubs associated with the account.
     */
    @JvmName("jkyvwehpboogvmtq")
    public suspend fun iotHubs(`value`: List<IotHubSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotHubs = mapped
    }

    /**
     * @param argument List of IoT Hubs associated with the account.
     */
    @JvmName("cgiysjtsyicibikm")
    public suspend fun iotHubs(argument: List<suspend IotHubSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IotHubSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotHubs = mapped
    }

    /**
     * @param argument List of IoT Hubs associated with the account.
     */
    @JvmName("dhejiidikvldxnat")
    public suspend fun iotHubs(vararg argument: suspend IotHubSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IotHubSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotHubs = mapped
    }

    /**
     * @param argument List of IoT Hubs associated with the account.
     */
    @JvmName("iupfcekvbhaippwq")
    public suspend fun iotHubs(argument: suspend IotHubSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IotHubSettingsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.iotHubs = mapped
    }

    /**
     * @param values List of IoT Hubs associated with the account.
     */
    @JvmName("rtkkxkuydmaptjjk")
    public suspend fun iotHubs(vararg values: IotHubSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iotHubs = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("txcvevienhmywdhj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ptiwhuiititxudtq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cwdqtldpglwbopka")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("oqinsgdwlymcsuvb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        accountName = accountName,
        diagnosticStorageProperties = diagnosticStorageProperties,
        enableDiagnostics = enableDiagnostics,
        instanceName = instanceName,
        iotHubs = iotHubs,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
