@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin

import com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2023-07-01. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnectionCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.DeviceUpdate.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         AccountName = "contoso",
 *         PrivateEndpointConnectionName = "peexample01",
 *         PrivateLinkServiceConnectionState = new AzureNative.DeviceUpdate.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Auto-Approved",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceupdate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceupdate.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &deviceupdate.PrivateEndpointConnectionArgs{
 * 			AccountName:                   pulumi.String("contoso"),
 * 			PrivateEndpointConnectionName: pulumi.String("peexample01"),
 * 			PrivateLinkServiceConnectionState: &deviceupdate.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Auto-Approved"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceupdate.PrivateEndpointConnection;
 * import com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .accountName("contoso")
 *             .privateEndpointConnectionName("peexample01")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "Auto-Approved"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceupdate:PrivateEndpointConnection peexample01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property accountName Account name.
 * @property groupIds Array of group IDs.
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property resourceGroupName The resource group name.
 */
public data class PrivateEndpointConnectionArgs(
    public val accountName: Output<String>? = null,
    public val groupIds: Output<List<String>>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var groupIds: Output<List<String>>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Account name.
     */
    @JvmName("rtosdwlqtlgtmnvj")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Array of group IDs.
     */
    @JvmName("jwrturnmnknxugyc")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("eplfxktsqukhyxtu")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values Array of group IDs.
     */
    @JvmName("gwpcrohknoooknia")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("yenkrhaayyfeofnj")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("sthibntwabuullqi")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("spcyyfpnfhthqlxm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Account name.
     */
    @JvmName("qowherkkrwbuwphc")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Array of group IDs.
     */
    @JvmName("pdpandrxsrgoyyuv")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values Array of group IDs.
     */
    @JvmName("awmthbmxdvonlvcp")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("lctsjraasqocfamb")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("aacbbqkqcnweolbs")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("vqrobfidexavkupd")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("haovayrtxrvrxstn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        accountName = accountName,
        groupIds = groupIds,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
    )
}
