@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin

import com.pulumi.azurenative.deviceupdate.kotlin.outputs.RemotePrivateEndpointResponse
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.RemotePrivateEndpointResponse.Companion.toKotlin as remotePrivateEndpointResponseToKotlin
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateEndpointConnectionProxy].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionProxyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionProxyArgs = PrivateEndpointConnectionProxyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionProxyArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionProxyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateEndpointConnectionProxy {
        val builtJavaResource =
            com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnectionProxy(builtJavaResource)
    }
}

/**
 * Private endpoint connection proxy details.
 * Azure REST API version: 2023-07-01. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnectionProxyCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionProxy = new AzureNative.DeviceUpdate.PrivateEndpointConnectionProxy("privateEndpointConnectionProxy", new()
 *     {
 *         AccountName = "contoso",
 *         PrivateEndpointConnectionProxyId = "peexample01",
 *         RemotePrivateEndpoint = new AzureNative.DeviceUpdate.Inputs.RemotePrivateEndpointArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}",
 *             ImmutableResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}",
 *             ImmutableSubscriptionId = "00000000-0000-0000-0000-000000000000",
 *             Location = "westus2",
 *             ManualPrivateLinkServiceConnections = new[]
 *             {
 *                 new AzureNative.DeviceUpdate.Inputs.PrivateLinkServiceConnectionArgs
 *                 {
 *                     GroupIds = new[]
 *                     {
 *                         "DeviceUpdate",
 *                     },
 *                     Name = "{privateEndpointConnectionProxyId}",
 *                     RequestMessage = "Please approve my connection, thanks.",
 *                 },
 *             },
 *             PrivateLinkServiceProxies = new[]
 *             {
 *                 new AzureNative.DeviceUpdate.Inputs.PrivateLinkServiceProxyArgs
 *                 {
 *                     GroupConnectivityInformation = new[] {},
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{privateEndpointConnectionProxyId}/privateLinkServiceProxies/{privateEndpointConnectionProxyId}",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceupdate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := deviceupdate.NewPrivateEndpointConnectionProxy(ctx, "privateEndpointConnectionProxy", &deviceupdate.PrivateEndpointConnectionProxyArgs{
 * AccountName: pulumi.String("contoso"),
 * PrivateEndpointConnectionProxyId: pulumi.String("peexample01"),
 * RemotePrivateEndpoint: deviceupdate.RemotePrivateEndpointResponse{
 * Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}"),
 * ImmutableResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}"),
 * ImmutableSubscriptionId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * Location: pulumi.String("westus2"),
 * ManualPrivateLinkServiceConnections: deviceupdate.PrivateLinkServiceConnectionArray{
 * &deviceupdate.PrivateLinkServiceConnectionArgs{
 * GroupIds: pulumi.StringArray{
 * pulumi.String("DeviceUpdate"),
 * },
 * Name: pulumi.String("{privateEndpointConnectionProxyId}"),
 * RequestMessage: pulumi.String("Please approve my connection, thanks."),
 * },
 * },
 * PrivateLinkServiceProxies: deviceupdate.PrivateLinkServiceProxyArray{
 * interface{}{
 * GroupConnectivityInformation: deviceupdate.GroupConnectivityInformationArray{
 * },
 * Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{privateEndpointConnectionProxyId}/privateLinkServiceProxies/{privateEndpointConnectionProxyId}"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("test-rg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxy;
 * import com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionProxy = new PrivateEndpointConnectionProxy("privateEndpointConnectionProxy", PrivateEndpointConnectionProxyArgs.builder()
 *             .accountName("contoso")
 *             .privateEndpointConnectionProxyId("peexample01")
 *             .remotePrivateEndpoint(Map.ofEntries(
 *                 Map.entry("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}"),
 *                 Map.entry("immutableResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}"),
 *                 Map.entry("immutableSubscriptionId", "00000000-0000-0000-0000-000000000000"),
 *                 Map.entry("location", "westus2"),
 *                 Map.entry("manualPrivateLinkServiceConnections", Map.ofEntries(
 *                     Map.entry("groupIds", "DeviceUpdate"),
 *                     Map.entry("name", "{privateEndpointConnectionProxyId}"),
 *                     Map.entry("requestMessage", "Please approve my connection, thanks.")
 *                 )),
 *                 Map.entry("privateLinkServiceProxies", Map.ofEntries(
 *                     Map.entry("groupConnectivityInformation", ),
 *                     Map.entry("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{privateEndpointConnectionProxyId}/privateLinkServiceProxies/{privateEndpointConnectionProxyId}")
 *                 ))
 *             ))
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceupdate:PrivateEndpointConnectionProxy peexample01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/privateEndpointConnectionProxies/{privateEndpointConnectionProxyId}
 * ```
 */
public class PrivateEndpointConnectionProxy internal constructor(
    override val javaResource: com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxy,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionProxyMapper) {
    /**
     * ETag from NRP.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the private endpoint connection proxy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Remote private endpoint details.
     */
    public val remotePrivateEndpoint: Output<RemotePrivateEndpointResponse>?
        get() = javaResource.remotePrivateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> remotePrivateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Operation status.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionProxyMapper : ResourceMapper<PrivateEndpointConnectionProxy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxy::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnectionProxy =
        PrivateEndpointConnectionProxy(
            javaResource as
                com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxy,
        )
}

/**
 * @see [PrivateEndpointConnectionProxy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnectionProxy].
 */
public suspend fun privateEndpointConnectionProxy(
    name: String,
    block: suspend PrivateEndpointConnectionProxyResourceBuilder.() -> Unit,
):
    PrivateEndpointConnectionProxy {
    val builder = PrivateEndpointConnectionProxyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnectionProxy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnectionProxy(name: String): PrivateEndpointConnectionProxy {
    val builder = PrivateEndpointConnectionProxyResourceBuilder()
    builder.name(name)
    return builder.build()
}
