@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.inputs

import com.pulumi.azurenative.deviceupdate.inputs.EncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The CMK encryption settings on the Device Update account.
 * @property keyVaultKeyUri The URI of the key vault
 * @property userAssignedIdentity The full resourceId of the user assigned identity to be used for key vault access. Identity has to be also assigned to the Account
 */
public data class EncryptionArgs(
    public val keyVaultKeyUri: Output<String>? = null,
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.inputs.EncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.inputs.EncryptionArgs =
        com.pulumi.azurenative.deviceupdate.inputs.EncryptionArgs.builder()
            .keyVaultKeyUri(keyVaultKeyUri?.applyValue({ args0 -> args0 }))
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionArgs].
 */
@PulumiTagMarker
public class EncryptionArgsBuilder internal constructor() {
    private var keyVaultKeyUri: Output<String>? = null

    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value The URI of the key vault
     */
    @JvmName("ufqmoopkcpjjwnch")
    public suspend fun keyVaultKeyUri(`value`: Output<String>) {
        this.keyVaultKeyUri = value
    }

    /**
     * @param value The full resourceId of the user assigned identity to be used for key vault access. Identity has to be also assigned to the Account
     */
    @JvmName("huigwxqsiaatpgpr")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The URI of the key vault
     */
    @JvmName("pxnooulxtrnmfngp")
    public suspend fun keyVaultKeyUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultKeyUri = mapped
    }

    /**
     * @param value The full resourceId of the user assigned identity to be used for key vault access. Identity has to be also assigned to the Account
     */
    @JvmName("wameawsqjkjyauon")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): EncryptionArgs = EncryptionArgs(
        keyVaultKeyUri = keyVaultKeyUri,
        userAssignedIdentity = userAssignedIdentity,
    )
}
