@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.inputs

import com.pulumi.azurenative.deviceupdate.inputs.PrivateLinkServiceConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Private link service connection details.
 * @property groupIds List of group IDs.
 * @property name Private link service connection name.
 * @property requestMessage Request message.
 */
public data class PrivateLinkServiceConnectionArgs(
    public val groupIds: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val requestMessage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.inputs.PrivateLinkServiceConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.inputs.PrivateLinkServiceConnectionArgs =
        com.pulumi.azurenative.deviceupdate.inputs.PrivateLinkServiceConnectionArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .requestMessage(requestMessage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var requestMessage: Output<String>? = null

    /**
     * @param value List of group IDs.
     */
    @JvmName("wovfaiypgoahmjrm")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("xxunqdegijddoyeb")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values List of group IDs.
     */
    @JvmName("iwkoigqmqxlrajde")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value Private link service connection name.
     */
    @JvmName("dwnvhroktcpymmte")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Request message.
     */
    @JvmName("oovqeiyntbfvlqef")
    public suspend fun requestMessage(`value`: Output<String>) {
        this.requestMessage = value
    }

    /**
     * @param value List of group IDs.
     */
    @JvmName("rwlejqdkyshwyewd")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values List of group IDs.
     */
    @JvmName("lotcyocscvhxsbjl")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value Private link service connection name.
     */
    @JvmName("nlbbnwarjxfdgkpo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Request message.
     */
    @JvmName("vcbwjfmapojsanyh")
    public suspend fun requestMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMessage = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionArgs = PrivateLinkServiceConnectionArgs(
        groupIds = groupIds,
        name = name,
        requestMessage = requestMessage,
    )
}
