@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.inputs

import com.pulumi.azurenative.deviceupdate.inputs.PrivateLinkServiceProxyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Private link service proxy details.
 * @property groupConnectivityInformation Group connectivity information.
 * @property id NRP resource ID.
 * @property remotePrivateLinkServiceConnectionState Remote private link service connection state
 */
public data class PrivateLinkServiceProxyArgs(
    public val groupConnectivityInformation: Output<List<GroupConnectivityInformationArgs>>? = null,
    public val id: Output<String>? = null,
    public val remotePrivateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.inputs.PrivateLinkServiceProxyArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.inputs.PrivateLinkServiceProxyArgs =
        com.pulumi.azurenative.deviceupdate.inputs.PrivateLinkServiceProxyArgs.builder()
            .groupConnectivityInformation(
                groupConnectivityInformation?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .remotePrivateLinkServiceConnectionState(
                remotePrivateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServiceProxyArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceProxyArgsBuilder internal constructor() {
    private var groupConnectivityInformation: Output<List<GroupConnectivityInformationArgs>>? = null

    private var id: Output<String>? = null

    private var remotePrivateLinkServiceConnectionState:
        Output<PrivateLinkServiceConnectionStateArgs>? = null

    /**
     * @param value Group connectivity information.
     */
    @JvmName("jbfyorniwfprqsbx")
    public suspend
    fun groupConnectivityInformation(`value`: Output<List<GroupConnectivityInformationArgs>>) {
        this.groupConnectivityInformation = value
    }

    @JvmName("enrmtjfqsaqgnqew")
    public suspend fun groupConnectivityInformation(
        vararg
        values: Output<GroupConnectivityInformationArgs>,
    ) {
        this.groupConnectivityInformation = Output.all(values.asList())
    }

    /**
     * @param values Group connectivity information.
     */
    @JvmName("bwennbrqsmhbusgi")
    public suspend
    fun groupConnectivityInformation(values: List<Output<GroupConnectivityInformationArgs>>) {
        this.groupConnectivityInformation = Output.all(values)
    }

    /**
     * @param value NRP resource ID.
     */
    @JvmName("kceqvuiafoxalxma")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Remote private link service connection state
     */
    @JvmName("bauodgphyiraqxdx")
    public suspend
    fun remotePrivateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.remotePrivateLinkServiceConnectionState = value
    }

    /**
     * @param value Group connectivity information.
     */
    @JvmName("omlxxafjssccvwej")
    public suspend
    fun groupConnectivityInformation(`value`: List<GroupConnectivityInformationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupConnectivityInformation = mapped
    }

    /**
     * @param argument Group connectivity information.
     */
    @JvmName("pvqhcvtoixjgdtoq")
    public suspend
    fun groupConnectivityInformation(argument: List<suspend GroupConnectivityInformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupConnectivityInformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.groupConnectivityInformation = mapped
    }

    /**
     * @param argument Group connectivity information.
     */
    @JvmName("ksspueymflqrdblh")
    public suspend fun groupConnectivityInformation(
        vararg
        argument: suspend GroupConnectivityInformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GroupConnectivityInformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.groupConnectivityInformation = mapped
    }

    /**
     * @param argument Group connectivity information.
     */
    @JvmName("djmnewqkkbllcufl")
    public suspend
    fun groupConnectivityInformation(argument: suspend GroupConnectivityInformationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GroupConnectivityInformationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.groupConnectivityInformation = mapped
    }

    /**
     * @param values Group connectivity information.
     */
    @JvmName("cvrkhvxidjcbfjjk")
    public suspend fun groupConnectivityInformation(vararg values: GroupConnectivityInformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupConnectivityInformation = mapped
    }

    /**
     * @param value NRP resource ID.
     */
    @JvmName("ytofygpquhonivts")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Remote private link service connection state
     */
    @JvmName("prxptbcrerssmcuf")
    public suspend
    fun remotePrivateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remotePrivateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Remote private link service connection state
     */
    @JvmName("swbstxpfbdwbiqdr")
    public suspend
    fun remotePrivateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.remotePrivateLinkServiceConnectionState = mapped
    }

    internal fun build(): PrivateLinkServiceProxyArgs = PrivateLinkServiceProxyArgs(
        groupConnectivityInformation = groupConnectivityInformation,
        id = id,
        remotePrivateLinkServiceConnectionState = remotePrivateLinkServiceConnectionState,
    )
}
