@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The status of the current operation.
 */
public enum class ProvisioningState(
    public val javaValue: com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState> {
    /**
     * Represents a succeeded operation.
     */
    Succeeded(com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState.Succeeded),

    /**
     * Represents a failed operation.
     */
    Failed(com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState.Failed),

    /**
     * Represents a canceled operation.
     */
    Canceled(com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState.Canceled),

    /**
     * Represents a pending operation.
     */
    Provisioning(com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState.Provisioning),

    /**
     * Represents a pending operation.
     */
    Updating(com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState.Updating),

    /**
     * Represents an operation under deletion.
     */
    Deleting(com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState.Deleting),

    /**
     * Represents an accepted operation.
     */
    Accepted(com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState.Accepted),
    ;

    override fun toJava(): com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.enums.ProvisioningState):
            ProvisioningState = ProvisioningState.values().first { it.javaValue == javaType }
    }
}
