@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.NetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The network profile of the machines in the pool.
 * @property subnetId The subnet id on which to put all machines created in the pool.
 */
public data class NetworkProfileArgs(
    public val subnetId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.devopsinfrastructure.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.NetworkProfileArgs.builder()
            .subnetId(subnetId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var subnetId: Output<String>? = null

    /**
     * @param value The subnet id on which to put all machines created in the pool.
     */
    @JvmName("nqgtxfppudygfpnk")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The subnet id on which to put all machines created in the pool.
     */
    @JvmName("wriinicvgnrkphva")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
    )
}
