@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.PoolImageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The VM image of the machines in the pool.
 * @property aliases List of aliases to reference the image by.
 * @property buffer The percentage of the buffer to be allocated to this image.
 * @property resourceId The resource id of the image.
 */
public data class PoolImageArgs(
    public val aliases: Output<List<String>>? = null,
    public val buffer: Output<String>? = null,
    public val resourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.PoolImageArgs> {
    override fun toJava(): com.pulumi.azurenative.devopsinfrastructure.inputs.PoolImageArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.PoolImageArgs.builder()
            .aliases(aliases?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .buffer(buffer?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PoolImageArgs].
 */
@PulumiTagMarker
public class PoolImageArgsBuilder internal constructor() {
    private var aliases: Output<List<String>>? = null

    private var buffer: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value List of aliases to reference the image by.
     */
    @JvmName("giaiffnrcvihlpwq")
    public suspend fun aliases(`value`: Output<List<String>>) {
        this.aliases = value
    }

    @JvmName("wovhuscnqpthujku")
    public suspend fun aliases(vararg values: Output<String>) {
        this.aliases = Output.all(values.asList())
    }

    /**
     * @param values List of aliases to reference the image by.
     */
    @JvmName("iicxydhnovyhylrw")
    public suspend fun aliases(values: List<Output<String>>) {
        this.aliases = Output.all(values)
    }

    /**
     * @param value The percentage of the buffer to be allocated to this image.
     */
    @JvmName("wuqlifxolucuwodx")
    public suspend fun buffer(`value`: Output<String>) {
        this.buffer = value
    }

    /**
     * @param value The resource id of the image.
     */
    @JvmName("qyewkeiodqkaywdj")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value List of aliases to reference the image by.
     */
    @JvmName("uihjhhfmslcmrqxe")
    public suspend fun aliases(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param values List of aliases to reference the image by.
     */
    @JvmName("rgavvwkrfemqdarf")
    public suspend fun aliases(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param value The percentage of the buffer to be allocated to this image.
     */
    @JvmName("nkwshwdegpchxeal")
    public suspend fun buffer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buffer = mapped
    }

    /**
     * @param value The resource id of the image.
     */
    @JvmName("vlqmpqfsyuaxtnoa")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): PoolImageArgs = PoolImageArgs(
        aliases = aliases,
        buffer = buffer,
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
