@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.StatefulArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Stateful profile meaning that the machines will be returned to the pool after running a job.
 * @property kind Discriminator property for AgentProfile.
 * Expected value is 'Stateful'.
 * @property maxAgentLifetime How long should stateful machines be kept around. The maximum is one week.
 * @property resourcePredictions Defines pool buffer.
 */
public data class StatefulArgs(
    public val kind: Output<String>,
    public val maxAgentLifetime: Output<String>,
    public val resourcePredictions: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.StatefulArgs> {
    override fun toJava(): com.pulumi.azurenative.devopsinfrastructure.inputs.StatefulArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.StatefulArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 }))
            .maxAgentLifetime(maxAgentLifetime.applyValue({ args0 -> args0 }))
            .resourcePredictions(resourcePredictions?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StatefulArgs].
 */
@PulumiTagMarker
public class StatefulArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var maxAgentLifetime: Output<String>? = null

    private var resourcePredictions: Output<Any>? = null

    /**
     * @param value Discriminator property for AgentProfile.
     * Expected value is 'Stateful'.
     */
    @JvmName("hwwdyanleqdxsrap")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value How long should stateful machines be kept around. The maximum is one week.
     */
    @JvmName("sxtmddmivqyxjgok")
    public suspend fun maxAgentLifetime(`value`: Output<String>) {
        this.maxAgentLifetime = value
    }

    /**
     * @param value Defines pool buffer.
     */
    @JvmName("dggqqptkysjrpmyt")
    public suspend fun resourcePredictions(`value`: Output<Any>) {
        this.resourcePredictions = value
    }

    /**
     * @param value Discriminator property for AgentProfile.
     * Expected value is 'Stateful'.
     */
    @JvmName("fhyawnovmsxkvkvl")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value How long should stateful machines be kept around. The maximum is one week.
     */
    @JvmName("omlsppmycesisqdv")
    public suspend fun maxAgentLifetime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxAgentLifetime = mapped
    }

    /**
     * @param value Defines pool buffer.
     */
    @JvmName("toihaexqoskbsihn")
    public suspend fun resourcePredictions(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePredictions = mapped
    }

    internal fun build(): StatefulArgs = StatefulArgs(
        kind = kind ?: throw PulumiNullFieldException("kind"),
        maxAgentLifetime = maxAgentLifetime ?: throw PulumiNullFieldException("maxAgentLifetime"),
        resourcePredictions = resourcePredictions,
    )
}
