@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.StatelessAgentProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Stateless profile meaning that the machines will be cleaned up after running a job.
 * @property kind Discriminator property for AgentProfile.
 * Expected value is 'Stateless'.
 * @property resourcePredictions Defines pool buffer.
 */
public data class StatelessAgentProfileArgs(
    public val kind: Output<String>,
    public val resourcePredictions: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.StatelessAgentProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.devopsinfrastructure.inputs.StatelessAgentProfileArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.StatelessAgentProfileArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 }))
            .resourcePredictions(resourcePredictions?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StatelessAgentProfileArgs].
 */
@PulumiTagMarker
public class StatelessAgentProfileArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var resourcePredictions: Output<Any>? = null

    /**
     * @param value Discriminator property for AgentProfile.
     * Expected value is 'Stateless'.
     */
    @JvmName("aqagiobburhbtenm")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Defines pool buffer.
     */
    @JvmName("vgspsbkjwieqvnmx")
    public suspend fun resourcePredictions(`value`: Output<Any>) {
        this.resourcePredictions = value
    }

    /**
     * @param value Discriminator property for AgentProfile.
     * Expected value is 'Stateless'.
     */
    @JvmName("seepfuubmjqbqcpx")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Defines pool buffer.
     */
    @JvmName("wssspgolnlbjgada")
    public suspend fun resourcePredictions(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePredictions = mapped
    }

    internal fun build(): StatelessAgentProfileArgs = StatelessAgentProfileArgs(
        kind = kind ?: throw PulumiNullFieldException("kind"),
        resourcePredictions = resourcePredictions,
    )
}
