@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Azure SKU of the machines in the pool.
 * @property name The Azure SKU name of the machines in the pool.
 * @property tier The Azure SKU tier of the machines in the pool.
 */
public data class DevOpsAzureSkuResponse(
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.DevOpsAzureSkuResponse):
            DevOpsAzureSkuResponse = DevOpsAzureSkuResponse(
            name = javaType.name(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
