@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The VM image of the machines in the pool.
 * @property aliases List of aliases to reference the image by.
 * @property buffer The percentage of the buffer to be allocated to this image.
 * @property resourceId The resource id of the image.
 */
public data class PoolImageResponse(
    public val aliases: List<String>? = null,
    public val buffer: String? = null,
    public val resourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.PoolImageResponse):
            PoolImageResponse = PoolImageResponse(
            aliases = javaType.aliases().map({ args0 -> args0 }),
            buffer = javaType.buffer().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId(),
        )
    }
}
