@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property dataPlaneFqdn DNS name for accessing DataPlane services
 * @property hostSuffix DNS suffix for public endpoints running in the Azure Dev Spaces Controller.
 * @property id Fully qualified resource Id for the resource.
 * @property location Region where the Azure resource is located.
 * @property name The name of the resource.
 * @property provisioningState Provisioning state of the Azure Dev Spaces Controller.
 * @property sku Model representing SKU for Azure Dev Spaces Controller.
 * @property tags Tags for the Azure resource.
 * @property targetContainerHostApiServerFqdn DNS of the target container host's API server
 * @property targetContainerHostResourceId Resource ID of the target container host
 * @property type The type of the resource.
 */
public data class GetControllerResult(
    public val dataPlaneFqdn: String,
    public val hostSuffix: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sku: SkuResponse,
    public val tags: Map<String, String>? = null,
    public val targetContainerHostApiServerFqdn: String,
    public val targetContainerHostResourceId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devspaces.outputs.GetControllerResult):
            GetControllerResult = GetControllerResult(
            dataPlaneFqdn = javaType.dataPlaneFqdn(),
            hostSuffix = javaType.hostSuffix(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.devspaces.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetContainerHostApiServerFqdn = javaType.targetContainerHostApiServerFqdn(),
            targetContainerHostResourceId = javaType.targetContainerHostResourceId(),
            type = javaType.type(),
        )
    }
}
