@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.EventResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.EventResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [NotificationChannel].
 */
@PulumiTagMarker
public class NotificationChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotificationChannelArgs = NotificationChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotificationChannelArgsBuilder.() -> Unit) {
        val builder = NotificationChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NotificationChannel {
        val builtJavaResource =
            com.pulumi.azurenative.devtestlab.NotificationChannel(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NotificationChannel(builtJavaResource)
    }
}

/**
 * A notification.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### NotificationChannels_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notificationChannel = new AzureNative.DevTestLab.NotificationChannel("notificationChannel", new()
 *     {
 *         Description = "Integration configured for auto-shutdown",
 *         EmailRecipient = "{email}",
 *         Events = new[]
 *         {
 *             new AzureNative.DevTestLab.Inputs.EventArgs
 *             {
 *                 EventName = "AutoShutdown",
 *             },
 *         },
 *         LabName = "{labName}",
 *         Name = "{notificationChannelName}",
 *         NotificationLocale = "en",
 *         ResourceGroupName = "resourceGroupName",
 *         WebHookUrl = "{webhookUrl}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewNotificationChannel(ctx, "notificationChannel", &devtestlab.NotificationChannelArgs{
 * 			Description:    pulumi.String("Integration configured for auto-shutdown"),
 * 			EmailRecipient: pulumi.String("{email}"),
 * 			Events: []devtestlab.EventArgs{
 * 				{
 * 					EventName: pulumi.String("AutoShutdown"),
 * 				},
 * 			},
 * 			LabName:            pulumi.String("{labName}"),
 * 			Name:               pulumi.String("{notificationChannelName}"),
 * 			NotificationLocale: pulumi.String("en"),
 * 			ResourceGroupName:  pulumi.String("resourceGroupName"),
 * 			WebHookUrl:         pulumi.String("{webhookUrl}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.NotificationChannel;
 * import com.pulumi.azurenative.devtestlab.NotificationChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notificationChannel = new NotificationChannel("notificationChannel", NotificationChannelArgs.builder()
 *             .description("Integration configured for auto-shutdown")
 *             .emailRecipient("{email}")
 *             .events(Map.of("eventName", "AutoShutdown"))
 *             .labName("{labName}")
 *             .name("{notificationChannelName}")
 *             .notificationLocale("en")
 *             .resourceGroupName("resourceGroupName")
 *             .webHookUrl("{webhookUrl}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:NotificationChannel {notificationChannelName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/notificationchannels/{name}
 * ```
 */
public class NotificationChannel internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.NotificationChannel,
) : KotlinCustomResource(javaResource, NotificationChannelMapper) {
    /**
     * The creation date of the notification channel.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Description of notification.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
     */
    public val emailRecipient: Output<String>?
        get() = javaResource.emailRecipient().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of event for which this notification is enabled.
     */
    public val events: Output<List<EventResponse>>?
        get() = javaResource.events().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The locale to use when sending a notification (fallback for unsupported languages is EN).
     */
    public val notificationLocale: Output<String>?
        get() = javaResource.notificationLocale().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })

    /**
     * The webhook URL to send notifications to.
     */
    public val webHookUrl: Output<String>?
        get() = javaResource.webHookUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object NotificationChannelMapper : ResourceMapper<NotificationChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.NotificationChannel::class == javaResource::class

    override fun map(javaResource: Resource): NotificationChannel = NotificationChannel(
        javaResource
            as com.pulumi.azurenative.devtestlab.NotificationChannel,
    )
}

/**
 * @see [NotificationChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotificationChannel].
 */
public suspend fun notificationChannel(
    name: String,
    block: suspend NotificationChannelResourceBuilder.() -> Unit,
): NotificationChannel {
    val builder = NotificationChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotificationChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notificationChannel(name: String): NotificationChannel {
    val builder = NotificationChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
