@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.azurenative.devtestlab.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * A Policy.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Policies_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.DevTestLab.Policy("policy", new()
 *     {
 *         Description = "{policyDescription}",
 *         EvaluatorType = "{policyEvaluatorType}",
 *         FactData = "{policyFactData}",
 *         FactName = "{policyFactName}",
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{policyName}",
 *         PolicySetName = "{policySetName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Status = "{policyStatus}",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         Threshold = "{policyThreshold}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewPolicy(ctx, "policy", &devtestlab.PolicyArgs{
 * 			Description:       pulumi.String("{policyDescription}"),
 * 			EvaluatorType:     pulumi.String("{policyEvaluatorType}"),
 * 			FactData:          pulumi.String("{policyFactData}"),
 * 			FactName:          pulumi.String("{policyFactName}"),
 * 			LabName:           pulumi.String("{labName}"),
 * 			Location:          pulumi.String("{location}"),
 * 			Name:              pulumi.String("{policyName}"),
 * 			PolicySetName:     pulumi.String("{policySetName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Status:            pulumi.String("{policyStatus}"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			Threshold: pulumi.String("{policyThreshold}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Policy;
 * import com.pulumi.azurenative.devtestlab.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .description("{policyDescription}")
 *             .evaluatorType("{policyEvaluatorType}")
 *             .factData("{policyFactData}")
 *             .factName("{policyFactName}")
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{policyName}")
 *             .policySetName("{policySetName}")
 *             .resourceGroupName("resourceGroupName")
 *             .status("{policyStatus}")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .threshold("{policyThreshold}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Policy {labName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/policysets/{policySetName}/policies/{name}
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * The creation date of the policy.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * The description of the policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy).
     */
    public val evaluatorType: Output<String>?
        get() = javaResource.evaluatorType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The fact data of the policy.
     */
    public val factData: Output<String>?
        get() = javaResource.factData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc.
     */
    public val factName: Output<String>?
        get() = javaResource.factName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The status of the policy.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
     */
    public val threshold: Output<String>?
        get() = javaResource.threshold().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.azurenative.devtestlab.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
