@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.ScheduleArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.EnableStatus
import com.pulumi.azurenative.devtestlab.kotlin.inputs.DayDetailsArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.DayDetailsArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.HourDetailsArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.HourDetailsArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.NotificationSettingsArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.NotificationSettingsArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.WeekDetailsArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.WeekDetailsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A schedule.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Schedules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new AzureNative.DevTestLab.Schedule("schedule", new()
 *     {
 *         DailyRecurrence = new AzureNative.DevTestLab.Inputs.DayDetailsArgs
 *         {
 *             Time = "{timeOfTheDayTheScheduleWillOccurEveryDay}",
 *         },
 *         HourlyRecurrence = new AzureNative.DevTestLab.Inputs.HourDetailsArgs
 *         {
 *             Minute = 30,
 *         },
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{scheduleName}",
 *         NotificationSettings = new AzureNative.DevTestLab.Inputs.NotificationSettingsArgs
 *         {
 *             EmailRecipient = "{email}",
 *             NotificationLocale = "EN",
 *             Status = "{Enabled|Disabled}",
 *             TimeInMinutes = 15,
 *             WebhookUrl = "{webhookUrl}",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Status = "{Enabled|Disabled}",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         TargetResourceId = "/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}",
 *         TaskType = "{myLabVmTaskType}",
 *         TimeZoneId = "Pacific Standard Time",
 *         WeeklyRecurrence = new AzureNative.DevTestLab.Inputs.WeekDetailsArgs
 *         {
 *             Time = "{timeOfTheDayTheScheduleWillOccurOnThoseDays}",
 *             Weekdays = new[]
 *             {
 *                 "Monday",
 *                 "Wednesday",
 *                 "Friday",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewSchedule(ctx, "schedule", &devtestlab.ScheduleArgs{
 * 			DailyRecurrence: &devtestlab.DayDetailsArgs{
 * 				Time: pulumi.String("{timeOfTheDayTheScheduleWillOccurEveryDay}"),
 * 			},
 * 			HourlyRecurrence: &devtestlab.HourDetailsArgs{
 * 				Minute: pulumi.Int(30),
 * 			},
 * 			LabName:  pulumi.String("{labName}"),
 * 			Location: pulumi.String("{location}"),
 * 			Name:     pulumi.String("{scheduleName}"),
 * 			NotificationSettings: &devtestlab.NotificationSettingsArgs{
 * 				EmailRecipient:     pulumi.String("{email}"),
 * 				NotificationLocale: pulumi.String("EN"),
 * 				Status:             pulumi.String("{Enabled|Disabled}"),
 * 				TimeInMinutes:      pulumi.Int(15),
 * 				WebhookUrl:         pulumi.String("{webhookUrl}"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Status:            pulumi.String("{Enabled|Disabled}"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			TargetResourceId: pulumi.String("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}"),
 * 			TaskType:         pulumi.String("{myLabVmTaskType}"),
 * 			TimeZoneId:       pulumi.String("Pacific Standard Time"),
 * 			WeeklyRecurrence: &devtestlab.WeekDetailsArgs{
 * 				Time: pulumi.String("{timeOfTheDayTheScheduleWillOccurOnThoseDays}"),
 * 				Weekdays: pulumi.StringArray{
 * 					pulumi.String("Monday"),
 * 					pulumi.String("Wednesday"),
 * 					pulumi.String("Friday"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Schedule;
 * import com.pulumi.azurenative.devtestlab.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new Schedule("schedule", ScheduleArgs.builder()
 *             .dailyRecurrence(Map.of("time", "{timeOfTheDayTheScheduleWillOccurEveryDay}"))
 *             .hourlyRecurrence(Map.of("minute", 30))
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{scheduleName}")
 *             .notificationSettings(Map.ofEntries(
 *                 Map.entry("emailRecipient", "{email}"),
 *                 Map.entry("notificationLocale", "EN"),
 *                 Map.entry("status", "{Enabled|Disabled}"),
 *                 Map.entry("timeInMinutes", 15),
 *                 Map.entry("webhookUrl", "{webhookUrl}")
 *             ))
 *             .resourceGroupName("resourceGroupName")
 *             .status("{Enabled|Disabled}")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .targetResourceId("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}")
 *             .taskType("{myLabVmTaskType}")
 *             .timeZoneId("Pacific Standard Time")
 *             .weeklyRecurrence(Map.ofEntries(
 *                 Map.entry("time", "{timeOfTheDayTheScheduleWillOccurOnThoseDays}"),
 *                 Map.entry("weekdays",
 *                     "Monday",
 *                     "Wednesday",
 *                     "Friday")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Schedule {scheduleName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/schedules/{name}
 * ```
 * @property dailyRecurrence If the schedule will occur once each day of the week, specify the daily recurrence.
 * @property hourlyRecurrence If the schedule will occur multiple times a day, specify the hourly recurrence.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the schedule.
 * @property notificationSettings Notification settings.
 * @property resourceGroupName The name of the resource group.
 * @property status The status of the schedule (i.e. Enabled, Disabled)
 * @property tags The tags of the resource.
 * @property targetResourceId The resource ID to which the schedule belongs
 * @property taskType The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
 * @property timeZoneId The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
 * @property weeklyRecurrence If the schedule will occur only some days of the week, specify the weekly recurrence.
 */
public data class ScheduleArgs(
    public val dailyRecurrence: Output<DayDetailsArgs>? = null,
    public val hourlyRecurrence: Output<HourDetailsArgs>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val notificationSettings: Output<NotificationSettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<Either<String, EnableStatus>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceId: Output<String>? = null,
    public val taskType: Output<String>? = null,
    public val timeZoneId: Output<String>? = null,
    public val weeklyRecurrence: Output<WeekDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.ScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.ScheduleArgs =
        com.pulumi.azurenative.devtestlab.ScheduleArgs.builder()
            .dailyRecurrence(dailyRecurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hourlyRecurrence(hourlyRecurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notificationSettings(
                notificationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceId(targetResourceId?.applyValue({ args0 -> args0 }))
            .taskType(taskType?.applyValue({ args0 -> args0 }))
            .timeZoneId(timeZoneId?.applyValue({ args0 -> args0 }))
            .weeklyRecurrence(
                weeklyRecurrence?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var dailyRecurrence: Output<DayDetailsArgs>? = null

    private var hourlyRecurrence: Output<HourDetailsArgs>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var notificationSettings: Output<NotificationSettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<Either<String, EnableStatus>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceId: Output<String>? = null

    private var taskType: Output<String>? = null

    private var timeZoneId: Output<String>? = null

    private var weeklyRecurrence: Output<WeekDetailsArgs>? = null

    /**
     * @param value If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    @JvmName("fxpdpetoebdrdujf")
    public suspend fun dailyRecurrence(`value`: Output<DayDetailsArgs>) {
        this.dailyRecurrence = value
    }

    /**
     * @param value If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    @JvmName("rymuofvfbilcefnp")
    public suspend fun hourlyRecurrence(`value`: Output<HourDetailsArgs>) {
        this.hourlyRecurrence = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("shuwyfwbcccewdod")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("seghpvxkpvqpjwhg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the schedule.
     */
    @JvmName("vsuwehmksotiivtx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Notification settings.
     */
    @JvmName("gbnwvdcuarfcuerx")
    public suspend fun notificationSettings(`value`: Output<NotificationSettingsArgs>) {
        this.notificationSettings = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yplqjclakdjninyg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("arpnwjlgdbwwmgxx")
    public suspend fun status(`value`: Output<Either<String, EnableStatus>>) {
        this.status = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("srhdxdsglqhhipuk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The resource ID to which the schedule belongs
     */
    @JvmName("uhwgtuosphvegvyr")
    public suspend fun targetResourceId(`value`: Output<String>) {
        this.targetResourceId = value
    }

    /**
     * @param value The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
     */
    @JvmName("klbrhabqqtsdaccj")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
     */
    @JvmName("jmblyxfnkijljwis")
    public suspend fun timeZoneId(`value`: Output<String>) {
        this.timeZoneId = value
    }

    /**
     * @param value If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    @JvmName("qqsusswnvboiycav")
    public suspend fun weeklyRecurrence(`value`: Output<WeekDetailsArgs>) {
        this.weeklyRecurrence = value
    }

    /**
     * @param value If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    @JvmName("noyoekacowdftkvr")
    public suspend fun dailyRecurrence(`value`: DayDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyRecurrence = mapped
    }

    /**
     * @param argument If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    @JvmName("pvdyieqqjevybqme")
    public suspend fun dailyRecurrence(argument: suspend DayDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = DayDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dailyRecurrence = mapped
    }

    /**
     * @param value If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    @JvmName("axlicqkrhckhlcun")
    public suspend fun hourlyRecurrence(`value`: HourDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hourlyRecurrence = mapped
    }

    /**
     * @param argument If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    @JvmName("vxlmsuumfoatkwwr")
    public suspend fun hourlyRecurrence(argument: suspend HourDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = HourDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hourlyRecurrence = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("xhbyfpiwcabioyql")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("wcgmoefmiovnlupn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the schedule.
     */
    @JvmName("feraafuyiwvujclk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Notification settings.
     */
    @JvmName("naojiwrdkpsbdtux")
    public suspend fun notificationSettings(`value`: NotificationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationSettings = mapped
    }

    /**
     * @param argument Notification settings.
     */
    @JvmName("rqccstgikhynriim")
    public suspend
    fun notificationSettings(argument: suspend NotificationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notificationSettings = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("geltkcbsenudkexi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("djifjeujywchrghm")
    public suspend fun status(`value`: Either<String, EnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("aqamnchasdoaksbs")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("apcmjxdxfkxqxlth")
    public fun status(`value`: EnableStatus) {
        val toBeMapped = Either.ofRight<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("whcpjgrbwakbyjjy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("ihdoutjuyulnyhqu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The resource ID to which the schedule belongs
     */
    @JvmName("jytueadqwmnesbvr")
    public suspend fun targetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceId = mapped
    }

    /**
     * @param value The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
     */
    @JvmName("rsxerqxaguxxjhxp")
    public suspend fun taskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
     */
    @JvmName("nsgmjbgmqlwhafwd")
    public suspend fun timeZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZoneId = mapped
    }

    /**
     * @param value If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    @JvmName("dtikapkopksnvmun")
    public suspend fun weeklyRecurrence(`value`: WeekDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyRecurrence = mapped
    }

    /**
     * @param argument If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    @JvmName("lmloieeycgxphyrq")
    public suspend fun weeklyRecurrence(argument: suspend WeekDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WeekDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.weeklyRecurrence = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        dailyRecurrence = dailyRecurrence,
        hourlyRecurrence = hourlyRecurrence,
        labName = labName,
        location = location,
        name = name,
        notificationSettings = notificationSettings,
        resourceGroupName = resourceGroupName,
        status = status,
        tags = tags,
        targetResourceId = targetResourceId,
        taskType = taskType,
        timeZoneId = timeZoneId,
        weeklyRecurrence = weeklyRecurrence,
    )
}
