@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.DayDetailsResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.HourDetailsResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.NotificationSettingsResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.WeekDetailsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devtestlab.kotlin.outputs.DayDetailsResponse.Companion.toKotlin as dayDetailsResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.HourDetailsResponse.Companion.toKotlin as hourDetailsResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.NotificationSettingsResponse.Companion.toKotlin as notificationSettingsResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.WeekDetailsResponse.Companion.toKotlin as weekDetailsResponseToKotlin

/**
 * Builder for [ServiceFabricSchedule].
 */
@PulumiTagMarker
public class ServiceFabricScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceFabricScheduleArgs = ServiceFabricScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceFabricScheduleArgsBuilder.() -> Unit) {
        val builder = ServiceFabricScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServiceFabricSchedule {
        val builtJavaResource =
            com.pulumi.azurenative.devtestlab.ServiceFabricSchedule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceFabricSchedule(builtJavaResource)
    }
}

/**
 * A schedule.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * ## Example Usage
 * ### ServiceFabricSchedules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceFabricSchedule = new AzureNative.DevTestLab.ServiceFabricSchedule("serviceFabricSchedule", new()
 *     {
 *         DailyRecurrence = new AzureNative.DevTestLab.Inputs.DayDetailsArgs
 *         {
 *             Time = "19:00",
 *         },
 *         HourlyRecurrence = new AzureNative.DevTestLab.Inputs.HourDetailsArgs
 *         {
 *             Minute = 0,
 *         },
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{scheduleName}",
 *         NotificationSettings = new AzureNative.DevTestLab.Inputs.NotificationSettingsArgs
 *         {
 *             EmailRecipient = "{email}",
 *             NotificationLocale = "EN",
 *             Status = "{Enabled|Disabled}",
 *             TimeInMinutes = 15,
 *             WebhookUrl = "{webhoolUrl}",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         ServiceFabricName = "{serviceFrabicName}",
 *         Status = "{Enabled|Disabled}",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         TargetResourceId = "/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.DevTestLab/labs/{labName}/users/{uniqueIdentifier}/servicefabrics/{serviceFrabicName}",
 *         TaskType = "{Unknown|LabVmsShutdownTask|LabVmsStartupTask|LabVmReclamationTask|ComputeVmShutdownTask}",
 *         TimeZoneId = "Pacific Standard Time",
 *         UserName = "@me",
 *         WeeklyRecurrence = new AzureNative.DevTestLab.Inputs.WeekDetailsArgs
 *         {
 *             Time = "19:00",
 *             Weekdays = new[]
 *             {
 *                 "Monday",
 *                 "Tuesday",
 *                 "Wednesday",
 *                 "Thursday",
 *                 "Friday",
 *                 "Saturday",
 *                 "Sunday",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewServiceFabricSchedule(ctx, "serviceFabricSchedule", &devtestlab.ServiceFabricScheduleArgs{
 * 			DailyRecurrence: &devtestlab.DayDetailsArgs{
 * 				Time: pulumi.String("19:00"),
 * 			},
 * 			HourlyRecurrence: &devtestlab.HourDetailsArgs{
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			LabName:  pulumi.String("{labName}"),
 * 			Location: pulumi.String("{location}"),
 * 			Name:     pulumi.String("{scheduleName}"),
 * 			NotificationSettings: &devtestlab.NotificationSettingsArgs{
 * 				EmailRecipient:     pulumi.String("{email}"),
 * 				NotificationLocale: pulumi.String("EN"),
 * 				Status:             pulumi.String("{Enabled|Disabled}"),
 * 				TimeInMinutes:      pulumi.Int(15),
 * 				WebhookUrl:         pulumi.String("{webhoolUrl}"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			ServiceFabricName: pulumi.String("{serviceFrabicName}"),
 * 			Status:            pulumi.String("{Enabled|Disabled}"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			TargetResourceId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.DevTestLab/labs/{labName}/users/{uniqueIdentifier}/servicefabrics/{serviceFrabicName}"),
 * 			TaskType:         pulumi.String("{Unknown|LabVmsShutdownTask|LabVmsStartupTask|LabVmReclamationTask|ComputeVmShutdownTask}"),
 * 			TimeZoneId:       pulumi.String("Pacific Standard Time"),
 * 			UserName:         pulumi.String("@me"),
 * 			WeeklyRecurrence: &devtestlab.WeekDetailsArgs{
 * 				Time: pulumi.String("19:00"),
 * 				Weekdays: pulumi.StringArray{
 * 					pulumi.String("Monday"),
 * 					pulumi.String("Tuesday"),
 * 					pulumi.String("Wednesday"),
 * 					pulumi.String("Thursday"),
 * 					pulumi.String("Friday"),
 * 					pulumi.String("Saturday"),
 * 					pulumi.String("Sunday"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.ServiceFabricSchedule;
 * import com.pulumi.azurenative.devtestlab.ServiceFabricScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceFabricSchedule = new ServiceFabricSchedule("serviceFabricSchedule", ServiceFabricScheduleArgs.builder()
 *             .dailyRecurrence(Map.of("time", "19:00"))
 *             .hourlyRecurrence(Map.of("minute", 0))
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{scheduleName}")
 *             .notificationSettings(Map.ofEntries(
 *                 Map.entry("emailRecipient", "{email}"),
 *                 Map.entry("notificationLocale", "EN"),
 *                 Map.entry("status", "{Enabled|Disabled}"),
 *                 Map.entry("timeInMinutes", 15),
 *                 Map.entry("webhookUrl", "{webhoolUrl}")
 *             ))
 *             .resourceGroupName("resourceGroupName")
 *             .serviceFabricName("{serviceFrabicName}")
 *             .status("{Enabled|Disabled}")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .targetResourceId("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.DevTestLab/labs/{labName}/users/{uniqueIdentifier}/servicefabrics/{serviceFrabicName}")
 *             .taskType("{Unknown|LabVmsShutdownTask|LabVmsStartupTask|LabVmReclamationTask|ComputeVmShutdownTask}")
 *             .timeZoneId("Pacific Standard Time")
 *             .userName("@me")
 *             .weeklyRecurrence(Map.ofEntries(
 *                 Map.entry("time", "19:00"),
 *                 Map.entry("weekdays",
 *                     "Monday",
 *                     "Tuesday",
 *                     "Wednesday",
 *                     "Thursday",
 *                     "Friday",
 *                     "Saturday",
 *                     "Sunday")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:ServiceFabricSchedule {scheduleName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/servicefabrics/{serviceFabricName}/schedules/{name}
 * ```
 */
public class ServiceFabricSchedule internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.ServiceFabricSchedule,
) : KotlinCustomResource(javaResource, ServiceFabricScheduleMapper) {
    /**
     * The creation date of the schedule.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    public val dailyRecurrence: Output<DayDetailsResponse>?
        get() = javaResource.dailyRecurrence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dayDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    public val hourlyRecurrence: Output<HourDetailsResponse>?
        get() = javaResource.hourlyRecurrence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hourDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Notification settings.
     */
    public val notificationSettings: Output<NotificationSettingsResponse>?
        get() = javaResource.notificationSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> notificationSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The status of the schedule (i.e. Enabled, Disabled)
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource ID to which the schedule belongs
     */
    public val targetResourceId: Output<String>?
        get() = javaResource.targetResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
     */
    public val taskType: Output<String>?
        get() = javaResource.taskType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
     */
    public val timeZoneId: Output<String>?
        get() = javaResource.timeZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })

    /**
     * If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    public val weeklyRecurrence: Output<WeekDetailsResponse>?
        get() = javaResource.weeklyRecurrence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> weekDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })
}

public object ServiceFabricScheduleMapper : ResourceMapper<ServiceFabricSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.ServiceFabricSchedule::class == javaResource::class

    override fun map(javaResource: Resource): ServiceFabricSchedule =
        ServiceFabricSchedule(javaResource as com.pulumi.azurenative.devtestlab.ServiceFabricSchedule)
}

/**
 * @see [ServiceFabricSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceFabricSchedule].
 */
public suspend fun serviceFabricSchedule(
    name: String,
    block: suspend ServiceFabricScheduleResourceBuilder.() -> Unit,
): ServiceFabricSchedule {
    val builder = ServiceFabricScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceFabricSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceFabricSchedule(name: String): ServiceFabricSchedule {
    val builder = ServiceFabricScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
