@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesFromPlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties for plan on a custom image.
 * @property id The id of the plan, equivalent to name of the plan
 * @property offer The offer for the plan from the marketplace image the custom image is derived from
 * @property publisher The publisher for the plan from the marketplace image the custom image is derived from
 */
public data class CustomImagePropertiesFromPlanArgs(
    public val id: Output<String>? = null,
    public val offer: Output<String>? = null,
    public val publisher: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesFromPlanArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesFromPlanArgs =
        com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesFromPlanArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .offer(offer?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomImagePropertiesFromPlanArgs].
 */
@PulumiTagMarker
public class CustomImagePropertiesFromPlanArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var offer: Output<String>? = null

    private var publisher: Output<String>? = null

    /**
     * @param value The id of the plan, equivalent to name of the plan
     */
    @JvmName("woasrlimkwcqktev")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The offer for the plan from the marketplace image the custom image is derived from
     */
    @JvmName("sshocruhpachgwop")
    public suspend fun offer(`value`: Output<String>) {
        this.offer = value
    }

    /**
     * @param value The publisher for the plan from the marketplace image the custom image is derived from
     */
    @JvmName("nxfvgkfpvasmghps")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The id of the plan, equivalent to name of the plan
     */
    @JvmName("vforyfaswaeiongw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The offer for the plan from the marketplace image the custom image is derived from
     */
    @JvmName("ofiqasrlfovkmytv")
    public suspend fun offer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offer = mapped
    }

    /**
     * @param value The publisher for the plan from the marketplace image the custom image is derived from
     */
    @JvmName("xantidcltmqjlaxs")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    internal fun build(): CustomImagePropertiesFromPlanArgs = CustomImagePropertiesFromPlanArgs(
        id = id,
        offer = offer,
        publisher = publisher,
    )
}
