@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.GalleryImageReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The reference information for an Azure Marketplace image.
 * @property offer The offer of the gallery image.
 * @property osType The OS type of the gallery image.
 * @property publisher The publisher of the gallery image.
 * @property sku The SKU of the gallery image.
 * @property version The version of the gallery image.
 */
public data class GalleryImageReferenceArgs(
    public val offer: Output<String>? = null,
    public val osType: Output<String>? = null,
    public val publisher: Output<String>? = null,
    public val sku: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.GalleryImageReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.GalleryImageReferenceArgs =
        com.pulumi.azurenative.devtestlab.inputs.GalleryImageReferenceArgs.builder()
            .offer(offer?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GalleryImageReferenceArgs].
 */
@PulumiTagMarker
public class GalleryImageReferenceArgsBuilder internal constructor() {
    private var offer: Output<String>? = null

    private var osType: Output<String>? = null

    private var publisher: Output<String>? = null

    private var sku: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The offer of the gallery image.
     */
    @JvmName("crykkmhhtfawdbvj")
    public suspend fun offer(`value`: Output<String>) {
        this.offer = value
    }

    /**
     * @param value The OS type of the gallery image.
     */
    @JvmName("vrodchwmkvmxhany")
    public suspend fun osType(`value`: Output<String>) {
        this.osType = value
    }

    /**
     * @param value The publisher of the gallery image.
     */
    @JvmName("aplwbtxguhfrcwia")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The SKU of the gallery image.
     */
    @JvmName("ikeppioqfvrugine")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value The version of the gallery image.
     */
    @JvmName("ngfvpblfuoppkygs")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The offer of the gallery image.
     */
    @JvmName("eotxufprbtbhrabn")
    public suspend fun offer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offer = mapped
    }

    /**
     * @param value The OS type of the gallery image.
     */
    @JvmName("pwconrukggemofhl")
    public suspend fun osType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The publisher of the gallery image.
     */
    @JvmName("jtfgwnkodvhrnmux")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The SKU of the gallery image.
     */
    @JvmName("mmbpgcdqitdnbfwy")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value The version of the gallery image.
     */
    @JvmName("bclpyywtcibgrbfm")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): GalleryImageReferenceArgs = GalleryImageReferenceArgs(
        offer = offer,
        osType = osType,
        publisher = publisher,
        sku = sku,
        version = version,
    )
}
