@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.GetDiskPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Specify the $expand query. Example: 'properties($select=diskType)'
 * @property labName The name of the lab.
 * @property name The name of the disk.
 * @property resourceGroupName The name of the resource group.
 * @property userName The name of the user profile.
 */
public data class GetDiskPlainArgs(
    public val expand: String? = null,
    public val labName: String,
    public val name: String,
    public val resourceGroupName: String,
    public val userName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.GetDiskPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.GetDiskPlainArgs =
        com.pulumi.azurenative.devtestlab.inputs.GetDiskPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .labName(labName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiskPlainArgs].
 */
@PulumiTagMarker
public class GetDiskPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var labName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var userName: String? = null

    /**
     * @param value Specify the $expand query. Example: 'properties($select=diskType)'
     */
    @JvmName("cbwjtrhtnytwhpij")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("jcmindvffhrjwhpv")
    public suspend fun labName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labName = mapped
    }

    /**
     * @param value The name of the disk.
     */
    @JvmName("fkvdrpstwycrvedl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fxlppxplcorlcxdk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("xxcnuhaatahgjbnh")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetDiskPlainArgs = GetDiskPlainArgs(
        expand = expand,
        labName = labName ?: throw PulumiNullFieldException("labName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
