@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.LabVirtualMachineCreationParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for creating a virtual machine.
 * @property allowClaim Indicates whether another user can take ownership of the virtual machine
 * @property artifacts The artifacts to be installed on the virtual machine.
 * @property bulkCreationParameters The number of virtual machine instances to create.
 * @property createdDate The creation date of the virtual machine.
 * @property customImageId The custom image identifier of the virtual machine.
 * @property dataDiskParameters New or existing data disks to attach to the virtual machine after creation
 * @property disallowPublicIpAddress Indicates whether the virtual machine is to be created without a public IP address.
 * @property environmentId The resource ID of the environment that contains this virtual machine, if any.
 * @property expirationDate The expiration date for VM.
 * @property galleryImageReference The Microsoft Azure Marketplace image reference of the virtual machine.
 * @property isAuthenticationWithSshKey Indicates whether this virtual machine uses an SSH key for authentication.
 * @property labSubnetName The lab subnet name of the virtual machine.
 * @property labVirtualNetworkId The lab virtual network identifier of the virtual machine.
 * @property location The location of the new virtual machine or environment
 * @property name The name of the virtual machine or environment
 * @property networkInterface The network interface properties.
 * @property notes The notes of the virtual machine.
 * @property ownerObjectId The object identifier of the owner of the virtual machine.
 * @property ownerUserPrincipalName The user principal name of the virtual machine owner.
 * @property password The password of the virtual machine administrator.
 * @property planId The id of the plan associated with the virtual machine image
 * @property scheduleParameters Virtual Machine schedules to be created
 * @property size The size of the virtual machine.
 * @property sshKey The SSH key of the virtual machine administrator.
 * @property storageType Storage type to use for virtual machine (i.e. Standard, Premium).
 * @property tags The tags of the resource.
 * @property userName The user name of the virtual machine.
 */
public data class LabVirtualMachineCreationParameterArgs(
    public val allowClaim: Output<Boolean>? = null,
    public val artifacts: Output<List<ArtifactInstallPropertiesArgs>>? = null,
    public val bulkCreationParameters: Output<BulkCreationParametersArgs>? = null,
    public val createdDate: Output<String>? = null,
    public val customImageId: Output<String>? = null,
    public val dataDiskParameters: Output<List<DataDiskPropertiesArgs>>? = null,
    public val disallowPublicIpAddress: Output<Boolean>? = null,
    public val environmentId: Output<String>? = null,
    public val expirationDate: Output<String>? = null,
    public val galleryImageReference: Output<GalleryImageReferenceArgs>? = null,
    public val isAuthenticationWithSshKey: Output<Boolean>? = null,
    public val labSubnetName: Output<String>? = null,
    public val labVirtualNetworkId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkInterface: Output<NetworkInterfacePropertiesArgs>? = null,
    public val notes: Output<String>? = null,
    public val ownerObjectId: Output<String>? = null,
    public val ownerUserPrincipalName: Output<String>? = null,
    public val password: Output<String>? = null,
    public val planId: Output<String>? = null,
    public val scheduleParameters: Output<List<ScheduleCreationParameterArgs>>? = null,
    public val size: Output<String>? = null,
    public val sshKey: Output<String>? = null,
    public val storageType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.LabVirtualMachineCreationParameterArgs> {
    override fun toJava():
        com.pulumi.azurenative.devtestlab.inputs.LabVirtualMachineCreationParameterArgs =
        com.pulumi.azurenative.devtestlab.inputs.LabVirtualMachineCreationParameterArgs.builder()
            .allowClaim(allowClaim?.applyValue({ args0 -> args0 }))
            .artifacts(
                artifacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .bulkCreationParameters(
                bulkCreationParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .createdDate(createdDate?.applyValue({ args0 -> args0 }))
            .customImageId(customImageId?.applyValue({ args0 -> args0 }))
            .dataDiskParameters(
                dataDiskParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .disallowPublicIpAddress(disallowPublicIpAddress?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .expirationDate(expirationDate?.applyValue({ args0 -> args0 }))
            .galleryImageReference(
                galleryImageReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isAuthenticationWithSshKey(isAuthenticationWithSshKey?.applyValue({ args0 -> args0 }))
            .labSubnetName(labSubnetName?.applyValue({ args0 -> args0 }))
            .labVirtualNetworkId(labVirtualNetworkId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkInterface(networkInterface?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .ownerObjectId(ownerObjectId?.applyValue({ args0 -> args0 }))
            .ownerUserPrincipalName(ownerUserPrincipalName?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .planId(planId?.applyValue({ args0 -> args0 }))
            .scheduleParameters(
                scheduleParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .size(size?.applyValue({ args0 -> args0 }))
            .sshKey(sshKey?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabVirtualMachineCreationParameterArgs].
 */
@PulumiTagMarker
public class LabVirtualMachineCreationParameterArgsBuilder internal constructor() {
    private var allowClaim: Output<Boolean>? = null

    private var artifacts: Output<List<ArtifactInstallPropertiesArgs>>? = null

    private var bulkCreationParameters: Output<BulkCreationParametersArgs>? = null

    private var createdDate: Output<String>? = null

    private var customImageId: Output<String>? = null

    private var dataDiskParameters: Output<List<DataDiskPropertiesArgs>>? = null

    private var disallowPublicIpAddress: Output<Boolean>? = null

    private var environmentId: Output<String>? = null

    private var expirationDate: Output<String>? = null

    private var galleryImageReference: Output<GalleryImageReferenceArgs>? = null

    private var isAuthenticationWithSshKey: Output<Boolean>? = null

    private var labSubnetName: Output<String>? = null

    private var labVirtualNetworkId: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var networkInterface: Output<NetworkInterfacePropertiesArgs>? = null

    private var notes: Output<String>? = null

    private var ownerObjectId: Output<String>? = null

    private var ownerUserPrincipalName: Output<String>? = null

    private var password: Output<String>? = null

    private var planId: Output<String>? = null

    private var scheduleParameters: Output<List<ScheduleCreationParameterArgs>>? = null

    private var size: Output<String>? = null

    private var sshKey: Output<String>? = null

    private var storageType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Indicates whether another user can take ownership of the virtual machine
     */
    @JvmName("qiaupvfdlrwacjie")
    public suspend fun allowClaim(`value`: Output<Boolean>) {
        this.allowClaim = value
    }

    /**
     * @param value The artifacts to be installed on the virtual machine.
     */
    @JvmName("qhtykgnwjwhflhyv")
    public suspend fun artifacts(`value`: Output<List<ArtifactInstallPropertiesArgs>>) {
        this.artifacts = value
    }

    @JvmName("pgglhffioiwtisje")
    public suspend fun artifacts(vararg values: Output<ArtifactInstallPropertiesArgs>) {
        this.artifacts = Output.all(values.asList())
    }

    /**
     * @param values The artifacts to be installed on the virtual machine.
     */
    @JvmName("fgxgyeaoenmilktw")
    public suspend fun artifacts(values: List<Output<ArtifactInstallPropertiesArgs>>) {
        this.artifacts = Output.all(values)
    }

    /**
     * @param value The number of virtual machine instances to create.
     */
    @JvmName("onjfoyigrxutjwup")
    public suspend fun bulkCreationParameters(`value`: Output<BulkCreationParametersArgs>) {
        this.bulkCreationParameters = value
    }

    /**
     * @param value The creation date of the virtual machine.
     */
    @JvmName("fktwvkfmkhlvmkeh")
    public suspend fun createdDate(`value`: Output<String>) {
        this.createdDate = value
    }

    /**
     * @param value The custom image identifier of the virtual machine.
     */
    @JvmName("jhxbvidrxynupmhh")
    public suspend fun customImageId(`value`: Output<String>) {
        this.customImageId = value
    }

    /**
     * @param value New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("ikfirnljtrrbldau")
    public suspend fun dataDiskParameters(`value`: Output<List<DataDiskPropertiesArgs>>) {
        this.dataDiskParameters = value
    }

    @JvmName("ksgyiajfambruvfm")
    public suspend fun dataDiskParameters(vararg values: Output<DataDiskPropertiesArgs>) {
        this.dataDiskParameters = Output.all(values.asList())
    }

    /**
     * @param values New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("avjmgnkrdemmfjdt")
    public suspend fun dataDiskParameters(values: List<Output<DataDiskPropertiesArgs>>) {
        this.dataDiskParameters = Output.all(values)
    }

    /**
     * @param value Indicates whether the virtual machine is to be created without a public IP address.
     */
    @JvmName("krscosucdngvnbhc")
    public suspend fun disallowPublicIpAddress(`value`: Output<Boolean>) {
        this.disallowPublicIpAddress = value
    }

    /**
     * @param value The resource ID of the environment that contains this virtual machine, if any.
     */
    @JvmName("udsmjqslatoxwjmy")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value The expiration date for VM.
     */
    @JvmName("xvaqkuuasksuqjyx")
    public suspend fun expirationDate(`value`: Output<String>) {
        this.expirationDate = value
    }

    /**
     * @param value The Microsoft Azure Marketplace image reference of the virtual machine.
     */
    @JvmName("dagiywcyxkthwhsh")
    public suspend fun galleryImageReference(`value`: Output<GalleryImageReferenceArgs>) {
        this.galleryImageReference = value
    }

    /**
     * @param value Indicates whether this virtual machine uses an SSH key for authentication.
     */
    @JvmName("buwvexkktvxovomc")
    public suspend fun isAuthenticationWithSshKey(`value`: Output<Boolean>) {
        this.isAuthenticationWithSshKey = value
    }

    /**
     * @param value The lab subnet name of the virtual machine.
     */
    @JvmName("mitypjcdqaadnest")
    public suspend fun labSubnetName(`value`: Output<String>) {
        this.labSubnetName = value
    }

    /**
     * @param value The lab virtual network identifier of the virtual machine.
     */
    @JvmName("aipavmpjagbckbpm")
    public suspend fun labVirtualNetworkId(`value`: Output<String>) {
        this.labVirtualNetworkId = value
    }

    /**
     * @param value The location of the new virtual machine or environment
     */
    @JvmName("wtwesaenmihsnhbg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the virtual machine or environment
     */
    @JvmName("wajlgvqblyxqvpcf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The network interface properties.
     */
    @JvmName("bxuowsocvaejyndi")
    public suspend fun networkInterface(`value`: Output<NetworkInterfacePropertiesArgs>) {
        this.networkInterface = value
    }

    /**
     * @param value The notes of the virtual machine.
     */
    @JvmName("cundxhgmqihlgxgu")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value The object identifier of the owner of the virtual machine.
     */
    @JvmName("rprnoepwaygvbldx")
    public suspend fun ownerObjectId(`value`: Output<String>) {
        this.ownerObjectId = value
    }

    /**
     * @param value The user principal name of the virtual machine owner.
     */
    @JvmName("ahvytwbtkdstifgp")
    public suspend fun ownerUserPrincipalName(`value`: Output<String>) {
        this.ownerUserPrincipalName = value
    }

    /**
     * @param value The password of the virtual machine administrator.
     */
    @JvmName("lkiwbtlblatcdual")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The id of the plan associated with the virtual machine image
     */
    @JvmName("woiodeadrqypxgtu")
    public suspend fun planId(`value`: Output<String>) {
        this.planId = value
    }

    /**
     * @param value Virtual Machine schedules to be created
     */
    @JvmName("hsrutgwkujisxddn")
    public suspend fun scheduleParameters(`value`: Output<List<ScheduleCreationParameterArgs>>) {
        this.scheduleParameters = value
    }

    @JvmName("erjuuihfbhlgyebv")
    public suspend fun scheduleParameters(vararg values: Output<ScheduleCreationParameterArgs>) {
        this.scheduleParameters = Output.all(values.asList())
    }

    /**
     * @param values Virtual Machine schedules to be created
     */
    @JvmName("vljbmvrnvddlltcx")
    public suspend fun scheduleParameters(values: List<Output<ScheduleCreationParameterArgs>>) {
        this.scheduleParameters = Output.all(values)
    }

    /**
     * @param value The size of the virtual machine.
     */
    @JvmName("nvdqxlfrlolgpfab")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The SSH key of the virtual machine administrator.
     */
    @JvmName("urojjrmbuiqasril")
    public suspend fun sshKey(`value`: Output<String>) {
        this.sshKey = value
    }

    /**
     * @param value Storage type to use for virtual machine (i.e. Standard, Premium).
     */
    @JvmName("qkcokilerilgxfvp")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("aocrwbxjeedmyeaf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user name of the virtual machine.
     */
    @JvmName("fbnashluvsqdbcee")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Indicates whether another user can take ownership of the virtual machine
     */
    @JvmName("ohhsxsmibmbnqpyd")
    public suspend fun allowClaim(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowClaim = mapped
    }

    /**
     * @param value The artifacts to be installed on the virtual machine.
     */
    @JvmName("lwnhogaumhocgndv")
    public suspend fun artifacts(`value`: List<ArtifactInstallPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param argument The artifacts to be installed on the virtual machine.
     */
    @JvmName("uluxtbaiexmixmnm")
    public suspend
    fun artifacts(argument: List<suspend ArtifactInstallPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ArtifactInstallPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param argument The artifacts to be installed on the virtual machine.
     */
    @JvmName("atdevxbkxwvlqynb")
    public suspend fun artifacts(
        vararg
        argument: suspend ArtifactInstallPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ArtifactInstallPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param argument The artifacts to be installed on the virtual machine.
     */
    @JvmName("okivvwmnowsyavxw")
    public suspend fun artifacts(argument: suspend ArtifactInstallPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ArtifactInstallPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param values The artifacts to be installed on the virtual machine.
     */
    @JvmName("rrtoruewbekseubb")
    public suspend fun artifacts(vararg values: ArtifactInstallPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param value The number of virtual machine instances to create.
     */
    @JvmName("cedholuuqelcaeer")
    public suspend fun bulkCreationParameters(`value`: BulkCreationParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bulkCreationParameters = mapped
    }

    /**
     * @param argument The number of virtual machine instances to create.
     */
    @JvmName("cbmwgdhmanqyummv")
    public suspend
    fun bulkCreationParameters(argument: suspend BulkCreationParametersArgsBuilder.() -> Unit) {
        val toBeMapped = BulkCreationParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bulkCreationParameters = mapped
    }

    /**
     * @param value The creation date of the virtual machine.
     */
    @JvmName("nilxdswaauwblool")
    public suspend fun createdDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdDate = mapped
    }

    /**
     * @param value The custom image identifier of the virtual machine.
     */
    @JvmName("vxhmkqvavlfqhcon")
    public suspend fun customImageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImageId = mapped
    }

    /**
     * @param value New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("lotchjonuobueiam")
    public suspend fun dataDiskParameters(`value`: List<DataDiskPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskParameters = mapped
    }

    /**
     * @param argument New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("jwmstqwqsxsthnif")
    public suspend
    fun dataDiskParameters(argument: List<suspend DataDiskPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataDiskPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDiskParameters = mapped
    }

    /**
     * @param argument New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("lklbyfpnvktbiiwp")
    public suspend fun dataDiskParameters(
        vararg
        argument: suspend DataDiskPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataDiskPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDiskParameters = mapped
    }

    /**
     * @param argument New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("dksgfxbasaehsecx")
    public suspend
    fun dataDiskParameters(argument: suspend DataDiskPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataDiskPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDiskParameters = mapped
    }

    /**
     * @param values New or existing data disks to attach to the virtual machine after creation
     */
    @JvmName("pqxcxpfexbxxmfpa")
    public suspend fun dataDiskParameters(vararg values: DataDiskPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDiskParameters = mapped
    }

    /**
     * @param value Indicates whether the virtual machine is to be created without a public IP address.
     */
    @JvmName("wingguwexprkesrr")
    public suspend fun disallowPublicIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disallowPublicIpAddress = mapped
    }

    /**
     * @param value The resource ID of the environment that contains this virtual machine, if any.
     */
    @JvmName("whuxoshrojeyixgr")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value The expiration date for VM.
     */
    @JvmName("ceyahcylwmkhpafa")
    public suspend fun expirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDate = mapped
    }

    /**
     * @param value The Microsoft Azure Marketplace image reference of the virtual machine.
     */
    @JvmName("ssldpuvojcbunfhb")
    public suspend fun galleryImageReference(`value`: GalleryImageReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryImageReference = mapped
    }

    /**
     * @param argument The Microsoft Azure Marketplace image reference of the virtual machine.
     */
    @JvmName("eefshnfjcjpkjmpm")
    public suspend
    fun galleryImageReference(argument: suspend GalleryImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryImageReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.galleryImageReference = mapped
    }

    /**
     * @param value Indicates whether this virtual machine uses an SSH key for authentication.
     */
    @JvmName("mbisilrialuaxyan")
    public suspend fun isAuthenticationWithSshKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAuthenticationWithSshKey = mapped
    }

    /**
     * @param value The lab subnet name of the virtual machine.
     */
    @JvmName("bmqtcsxlarhqnjpn")
    public suspend fun labSubnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labSubnetName = mapped
    }

    /**
     * @param value The lab virtual network identifier of the virtual machine.
     */
    @JvmName("mojbtyevjamfamld")
    public suspend fun labVirtualNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labVirtualNetworkId = mapped
    }

    /**
     * @param value The location of the new virtual machine or environment
     */
    @JvmName("dwgmuegywiwfvnfa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the virtual machine or environment
     */
    @JvmName("foqsuljpjwsjndja")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The network interface properties.
     */
    @JvmName("koltwtsbrndlaiwg")
    public suspend fun networkInterface(`value`: NetworkInterfacePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterface = mapped
    }

    /**
     * @param argument The network interface properties.
     */
    @JvmName("jlkxydiiyujnwmra")
    public suspend
    fun networkInterface(argument: suspend NetworkInterfacePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkInterfacePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkInterface = mapped
    }

    /**
     * @param value The notes of the virtual machine.
     */
    @JvmName("usyvldqmagsplygu")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value The object identifier of the owner of the virtual machine.
     */
    @JvmName("ufttgkthpnkbyfxd")
    public suspend fun ownerObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerObjectId = mapped
    }

    /**
     * @param value The user principal name of the virtual machine owner.
     */
    @JvmName("vrvosyhqyoervacx")
    public suspend fun ownerUserPrincipalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerUserPrincipalName = mapped
    }

    /**
     * @param value The password of the virtual machine administrator.
     */
    @JvmName("yvthvradybxukego")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The id of the plan associated with the virtual machine image
     */
    @JvmName("biqvbccxvusjdsel")
    public suspend fun planId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planId = mapped
    }

    /**
     * @param value Virtual Machine schedules to be created
     */
    @JvmName("cfwmfafdxoxqmvhw")
    public suspend fun scheduleParameters(`value`: List<ScheduleCreationParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleParameters = mapped
    }

    /**
     * @param argument Virtual Machine schedules to be created
     */
    @JvmName("ulhwtkfhvosbxqmc")
    public suspend
    fun scheduleParameters(argument: List<suspend ScheduleCreationParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScheduleCreationParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scheduleParameters = mapped
    }

    /**
     * @param argument Virtual Machine schedules to be created
     */
    @JvmName("weahsnkfajwpsfun")
    public suspend fun scheduleParameters(
        vararg
        argument: suspend ScheduleCreationParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ScheduleCreationParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scheduleParameters = mapped
    }

    /**
     * @param argument Virtual Machine schedules to be created
     */
    @JvmName("eeocvqkofmmevajk")
    public suspend
    fun scheduleParameters(argument: suspend ScheduleCreationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScheduleCreationParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.scheduleParameters = mapped
    }

    /**
     * @param values Virtual Machine schedules to be created
     */
    @JvmName("gqyahhtlybtejfda")
    public suspend fun scheduleParameters(vararg values: ScheduleCreationParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleParameters = mapped
    }

    /**
     * @param value The size of the virtual machine.
     */
    @JvmName("keinvbujuyeeloyl")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The SSH key of the virtual machine administrator.
     */
    @JvmName("jefhabfbaqppruml")
    public suspend fun sshKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshKey = mapped
    }

    /**
     * @param value Storage type to use for virtual machine (i.e. Standard, Premium).
     */
    @JvmName("pxxtxgtcwyksgylh")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("qinlutaepvslxvxo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("uvxyqmhxuphyfcup")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user name of the virtual machine.
     */
    @JvmName("bspaekcbwapabvqp")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): LabVirtualMachineCreationParameterArgs =
        LabVirtualMachineCreationParameterArgs(
            allowClaim = allowClaim,
            artifacts = artifacts,
            bulkCreationParameters = bulkCreationParameters,
            createdDate = createdDate,
            customImageId = customImageId,
            dataDiskParameters = dataDiskParameters,
            disallowPublicIpAddress = disallowPublicIpAddress,
            environmentId = environmentId,
            expirationDate = expirationDate,
            galleryImageReference = galleryImageReference,
            isAuthenticationWithSshKey = isAuthenticationWithSshKey,
            labSubnetName = labSubnetName,
            labVirtualNetworkId = labVirtualNetworkId,
            location = location,
            name = name,
            networkInterface = networkInterface,
            notes = notes,
            ownerObjectId = ownerObjectId,
            ownerUserPrincipalName = ownerUserPrincipalName,
            password = password,
            planId = planId,
            scheduleParameters = scheduleParameters,
            size = size,
            sshKey = sshKey,
            storageType = storageType,
            tags = tags,
            userName = userName,
        )
}
