@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.NetworkInterfacePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of a network interface.
 * @property dnsName The DNS name.
 * @property privateIpAddress The private IP address.
 * @property publicIpAddress The public IP address.
 * @property publicIpAddressId The resource ID of the public IP address.
 * @property rdpAuthority The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
 * @property sharedPublicIpAddressConfiguration The configuration for sharing a public IP address across multiple virtual machines.
 * @property sshAuthority The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
 * @property subnetId The resource ID of the sub net.
 * @property virtualNetworkId The resource ID of the virtual network.
 */
public data class NetworkInterfacePropertiesArgs(
    public val dnsName: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val publicIpAddress: Output<String>? = null,
    public val publicIpAddressId: Output<String>? = null,
    public val rdpAuthority: Output<String>? = null,
    public val sharedPublicIpAddressConfiguration: Output<SharedPublicIpAddressConfigurationArgs>? =
        null,
    public val sshAuthority: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val virtualNetworkId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.NetworkInterfacePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.NetworkInterfacePropertiesArgs =
        com.pulumi.azurenative.devtestlab.inputs.NetworkInterfacePropertiesArgs.builder()
            .dnsName(dnsName?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .publicIpAddress(publicIpAddress?.applyValue({ args0 -> args0 }))
            .publicIpAddressId(publicIpAddressId?.applyValue({ args0 -> args0 }))
            .rdpAuthority(rdpAuthority?.applyValue({ args0 -> args0 }))
            .sharedPublicIpAddressConfiguration(
                sharedPublicIpAddressConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sshAuthority(sshAuthority?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .virtualNetworkId(virtualNetworkId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfacePropertiesArgs].
 */
@PulumiTagMarker
public class NetworkInterfacePropertiesArgsBuilder internal constructor() {
    private var dnsName: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var publicIpAddress: Output<String>? = null

    private var publicIpAddressId: Output<String>? = null

    private var rdpAuthority: Output<String>? = null

    private var sharedPublicIpAddressConfiguration: Output<SharedPublicIpAddressConfigurationArgs>? =
        null

    private var sshAuthority: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var virtualNetworkId: Output<String>? = null

    /**
     * @param value The DNS name.
     */
    @JvmName("tvdybgesurcyrwlp")
    public suspend fun dnsName(`value`: Output<String>) {
        this.dnsName = value
    }

    /**
     * @param value The private IP address.
     */
    @JvmName("yoresvmnjomjldbn")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value The public IP address.
     */
    @JvmName("mghlwofxkiheecco")
    public suspend fun publicIpAddress(`value`: Output<String>) {
        this.publicIpAddress = value
    }

    /**
     * @param value The resource ID of the public IP address.
     */
    @JvmName("cbfpedktsidrmwwa")
    public suspend fun publicIpAddressId(`value`: Output<String>) {
        this.publicIpAddressId = value
    }

    /**
     * @param value The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
     */
    @JvmName("fvbgllomdjasyreo")
    public suspend fun rdpAuthority(`value`: Output<String>) {
        this.rdpAuthority = value
    }

    /**
     * @param value The configuration for sharing a public IP address across multiple virtual machines.
     */
    @JvmName("ritxvmmgvsttawcq")
    public suspend
    fun sharedPublicIpAddressConfiguration(`value`: Output<SharedPublicIpAddressConfigurationArgs>) {
        this.sharedPublicIpAddressConfiguration = value
    }

    /**
     * @param value The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
     */
    @JvmName("vrnfnekkhhstmdrr")
    public suspend fun sshAuthority(`value`: Output<String>) {
        this.sshAuthority = value
    }

    /**
     * @param value The resource ID of the sub net.
     */
    @JvmName("gyxrrknudufmqbey")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The resource ID of the virtual network.
     */
    @JvmName("grlbenolyotihwqt")
    public suspend fun virtualNetworkId(`value`: Output<String>) {
        this.virtualNetworkId = value
    }

    /**
     * @param value The DNS name.
     */
    @JvmName("mnrwsusyyspbukqa")
    public suspend fun dnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsName = mapped
    }

    /**
     * @param value The private IP address.
     */
    @JvmName("auyioaivpbhryrjx")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value The public IP address.
     */
    @JvmName("xuosxlbbuqlhxegd")
    public suspend fun publicIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddress = mapped
    }

    /**
     * @param value The resource ID of the public IP address.
     */
    @JvmName("ubhgjyveohakkvmq")
    public suspend fun publicIpAddressId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddressId = mapped
    }

    /**
     * @param value The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
     */
    @JvmName("doyovarmeumrpphh")
    public suspend fun rdpAuthority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdpAuthority = mapped
    }

    /**
     * @param value The configuration for sharing a public IP address across multiple virtual machines.
     */
    @JvmName("dyrpgdtdioixmhuq")
    public suspend
    fun sharedPublicIpAddressConfiguration(`value`: SharedPublicIpAddressConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedPublicIpAddressConfiguration = mapped
    }

    /**
     * @param argument The configuration for sharing a public IP address across multiple virtual machines.
     */
    @JvmName("esutkxxpahnitwjl")
    public suspend
    fun sharedPublicIpAddressConfiguration(argument: suspend SharedPublicIpAddressConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SharedPublicIpAddressConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharedPublicIpAddressConfiguration = mapped
    }

    /**
     * @param value The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
     */
    @JvmName("jajdkpwysiaknowu")
    public suspend fun sshAuthority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshAuthority = mapped
    }

    /**
     * @param value The resource ID of the sub net.
     */
    @JvmName("mrlsnlrkjnvbnxid")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value The resource ID of the virtual network.
     */
    @JvmName("koehaoxxptjkjrwa")
    public suspend fun virtualNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkId = mapped
    }

    internal fun build(): NetworkInterfacePropertiesArgs = NetworkInterfacePropertiesArgs(
        dnsName = dnsName,
        privateIpAddress = privateIpAddress,
        publicIpAddress = publicIpAddress,
        publicIpAddressId = publicIpAddressId,
        rdpAuthority = rdpAuthority,
        sharedPublicIpAddressConfiguration = sharedPublicIpAddressConfiguration,
        sshAuthority = sshAuthority,
        subnetId = subnetId,
        virtualNetworkId = virtualNetworkId,
    )
}
