@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.SubnetSharedPublicIpAddressConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Configuration for public IP address sharing.
 * @property allowedPorts Backend ports that virtual machines on this subnet are allowed to expose
 */
public data class SubnetSharedPublicIpAddressConfigurationArgs(
    public val allowedPorts: Output<List<PortArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.SubnetSharedPublicIpAddressConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.devtestlab.inputs.SubnetSharedPublicIpAddressConfigurationArgs =
        com.pulumi.azurenative.devtestlab.inputs.SubnetSharedPublicIpAddressConfigurationArgs.builder()
            .allowedPorts(
                allowedPorts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SubnetSharedPublicIpAddressConfigurationArgs].
 */
@PulumiTagMarker
public class SubnetSharedPublicIpAddressConfigurationArgsBuilder internal constructor() {
    private var allowedPorts: Output<List<PortArgs>>? = null

    /**
     * @param value Backend ports that virtual machines on this subnet are allowed to expose
     */
    @JvmName("nejnrdcgpnplrqsp")
    public suspend fun allowedPorts(`value`: Output<List<PortArgs>>) {
        this.allowedPorts = value
    }

    @JvmName("pjbdbkdwdguyccaf")
    public suspend fun allowedPorts(vararg values: Output<PortArgs>) {
        this.allowedPorts = Output.all(values.asList())
    }

    /**
     * @param values Backend ports that virtual machines on this subnet are allowed to expose
     */
    @JvmName("hydllsfuqtjyduek")
    public suspend fun allowedPorts(values: List<Output<PortArgs>>) {
        this.allowedPorts = Output.all(values)
    }

    /**
     * @param value Backend ports that virtual machines on this subnet are allowed to expose
     */
    @JvmName("vbfutqceehyhyngl")
    public suspend fun allowedPorts(`value`: List<PortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedPorts = mapped
    }

    /**
     * @param argument Backend ports that virtual machines on this subnet are allowed to expose
     */
    @JvmName("ihjkolffffqwxkst")
    public suspend fun allowedPorts(argument: List<suspend PortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PortArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.allowedPorts = mapped
    }

    /**
     * @param argument Backend ports that virtual machines on this subnet are allowed to expose
     */
    @JvmName("yiumxlgiamnmlvag")
    public suspend fun allowedPorts(vararg argument: suspend PortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PortArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.allowedPorts = mapped
    }

    /**
     * @param argument Backend ports that virtual machines on this subnet are allowed to expose
     */
    @JvmName("nswdpqicmmuwpleg")
    public suspend fun allowedPorts(argument: suspend PortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PortArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.allowedPorts = mapped
    }

    /**
     * @param values Backend ports that virtual machines on this subnet are allowed to expose
     */
    @JvmName("hckqkxagfwwryoef")
    public suspend fun allowedPorts(vararg values: PortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedPorts = mapped
    }

    internal fun build(): SubnetSharedPublicIpAddressConfigurationArgs =
        SubnetSharedPublicIpAddressConfigurationArgs(
            allowedPorts = allowedPorts,
        )
}
