@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.UserIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity attributes of a lab user.
 * @property appId Set to the app Id of the client JWT making the request.
 * @property objectId Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
 * @property principalId Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
 * @property principalName Set to the principal name / UPN of the client JWT making the request.
 * @property tenantId Set to the tenant ID of the client JWT making the request.
 */
public data class UserIdentityArgs(
    public val appId: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val principalName: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.UserIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.UserIdentityArgs =
        com.pulumi.azurenative.devtestlab.inputs.UserIdentityArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .principalName(principalName?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserIdentityArgs].
 */
@PulumiTagMarker
public class UserIdentityArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var objectId: Output<String>? = null

    private var principalId: Output<String>? = null

    private var principalName: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Set to the app Id of the client JWT making the request.
     */
    @JvmName("oondrnnybxunpkyb")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
     */
    @JvmName("grtfdhwhsgyapejy")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
     */
    @JvmName("lsfxvvxxxnhauigb")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Set to the principal name / UPN of the client JWT making the request.
     */
    @JvmName("lcoxtbmxxbeihhhq")
    public suspend fun principalName(`value`: Output<String>) {
        this.principalName = value
    }

    /**
     * @param value Set to the tenant ID of the client JWT making the request.
     */
    @JvmName("gtovhqfhfaiqftfm")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Set to the app Id of the client JWT making the request.
     */
    @JvmName("kjbqlinghmcarlbb")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
     */
    @JvmName("kfeshjsxdvnstrsq")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
     */
    @JvmName("jwntlpifneblwujs")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Set to the principal name / UPN of the client JWT making the request.
     */
    @JvmName("upgxldjhigjhcqjy")
    public suspend fun principalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalName = mapped
    }

    /**
     * @param value Set to the tenant ID of the client JWT making the request.
     */
    @JvmName("dnlappmshextivao")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): UserIdentityArgs = UserIdentityArgs(
        appId = appId,
        objectId = objectId,
        principalId = principalId,
        principalName = principalName,
        tenantId = tenantId,
    )
}
