@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.WeekDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a weekly schedule.
 * @property time The time of the day the schedule will occur.
 * @property weekdays The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
 */
public data class WeekDetailsArgs(
    public val time: Output<String>? = null,
    public val weekdays: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.WeekDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.WeekDetailsArgs =
        com.pulumi.azurenative.devtestlab.inputs.WeekDetailsArgs.builder()
            .time(time?.applyValue({ args0 -> args0 }))
            .weekdays(weekdays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WeekDetailsArgs].
 */
@PulumiTagMarker
public class WeekDetailsArgsBuilder internal constructor() {
    private var time: Output<String>? = null

    private var weekdays: Output<List<String>>? = null

    /**
     * @param value The time of the day the schedule will occur.
     */
    @JvmName("uhftxmaxnpolnhrx")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
     */
    @JvmName("vumlnyubehsdvsli")
    public suspend fun weekdays(`value`: Output<List<String>>) {
        this.weekdays = value
    }

    @JvmName("cgcafqjeoibvtohw")
    public suspend fun weekdays(vararg values: Output<String>) {
        this.weekdays = Output.all(values.asList())
    }

    /**
     * @param values The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
     */
    @JvmName("wiswaihoxlemwrch")
    public suspend fun weekdays(values: List<Output<String>>) {
        this.weekdays = Output.all(values)
    }

    /**
     * @param value The time of the day the schedule will occur.
     */
    @JvmName("ouxtcnqhluoonbhw")
    public suspend fun time(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.time = mapped
    }

    /**
     * @param value The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
     */
    @JvmName("laqjursnsjvgkncp")
    public suspend fun weekdays(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weekdays = mapped
    }

    /**
     * @param values The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
     */
    @JvmName("qeqlvwlyjbfgqbql")
    public suspend fun weekdays(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weekdays = mapped
    }

    internal fun build(): WeekDetailsArgs = WeekDetailsArgs(
        time = time,
        weekdays = weekdays,
    )
}
