@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.WindowsOsInfoArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.WindowsOsState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about a Windows OS.
 * @property windowsOsState The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
 */
public data class WindowsOsInfoArgs(
    public val windowsOsState: Output<Either<String, WindowsOsState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.WindowsOsInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.WindowsOsInfoArgs =
        com.pulumi.azurenative.devtestlab.inputs.WindowsOsInfoArgs.builder()
            .windowsOsState(
                windowsOsState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WindowsOsInfoArgs].
 */
@PulumiTagMarker
public class WindowsOsInfoArgsBuilder internal constructor() {
    private var windowsOsState: Output<Either<String, WindowsOsState>>? = null

    /**
     * @param value The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
     */
    @JvmName("ouptauhlyttwaxur")
    public suspend fun windowsOsState(`value`: Output<Either<String, WindowsOsState>>) {
        this.windowsOsState = value
    }

    /**
     * @param value The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
     */
    @JvmName("icsblqtnjrdjajww")
    public suspend fun windowsOsState(`value`: Either<String, WindowsOsState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsOsState = mapped
    }

    /**
     * @param value The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
     */
    @JvmName("yyvohcsksnnvtexk")
    public fun windowsOsState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WindowsOsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.windowsOsState = mapped
    }

    /**
     * @param value The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
     */
    @JvmName("uqpxpikwuavpimsy")
    public fun windowsOsState(`value`: WindowsOsState) {
        val toBeMapped = Either.ofRight<String, WindowsOsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.windowsOsState = mapped
    }

    internal fun build(): WindowsOsInfoArgs = WindowsOsInfoArgs(
        windowsOsState = windowsOsState,
    )
}
