@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a virtual machine returned by the Microsoft.Compute API.
 * @property dataDiskIds Gets data disks blob uri for the virtual machine.
 * @property dataDisks Gets all data disks attached to the virtual machine.
 * @property networkInterfaceId Gets the network interface ID of the virtual machine.
 * @property osDiskId Gets OS disk blob uri for the virtual machine.
 * @property osType Gets the OS type of the virtual machine.
 * @property statuses Gets the statuses of the virtual machine.
 * @property vmSize Gets the size of the virtual machine.
 */
public data class ComputeVmPropertiesResponse(
    public val dataDiskIds: List<String>? = null,
    public val dataDisks: List<ComputeDataDiskResponse>? = null,
    public val networkInterfaceId: String? = null,
    public val osDiskId: String? = null,
    public val osType: String? = null,
    public val statuses: List<ComputeVmInstanceViewStatusResponse>? = null,
    public val vmSize: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.ComputeVmPropertiesResponse):
            ComputeVmPropertiesResponse = ComputeVmPropertiesResponse(
            dataDiskIds = javaType.dataDiskIds().map({ args0 -> args0 }),
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.ComputeDataDiskResponse.Companion.toKotlin(args0)
                })
            }),
            networkInterfaceId = javaType.networkInterfaceId().map({ args0 -> args0 }).orElse(null),
            osDiskId = javaType.osDiskId().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.ComputeVmInstanceViewStatusResponse.Companion.toKotlin(args0)
                })
            }),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
