@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Subnet information as returned by the Microsoft.Network API.
 * @property id Gets or sets the identifier.
 * @property name Gets or sets the name.
 */
public data class ExternalSubnetResponse(
    public val id: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.ExternalSubnetResponse):
            ExternalSubnetResponse = ExternalSubnetResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
