@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A custom image.
 * @property author The author of the custom image.
 * @property creationDate The creation date of the custom image.
 * @property customImagePlan Storage information about the plan related to this custom image
 * @property dataDiskStorageInfo Storage information about the data disks present in the custom image
 * @property description The description of the custom image.
 * @property id The identifier of the resource.
 * @property isPlanAuthorized Whether or not the custom images underlying offer/plan has been enabled for programmatic deployment
 * @property location The location of the resource.
 * @property managedImageId The Managed Image Id backing the custom image.
 * @property managedSnapshotId The Managed Snapshot Id backing the custom image.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 * @property vhd The VHD from which the image is to be created.
 * @property vm The virtual machine from which the image is to be created.
 */
public data class GetCustomImageResult(
    public val author: String? = null,
    public val creationDate: String,
    public val customImagePlan: CustomImagePropertiesFromPlanResponse? = null,
    public val dataDiskStorageInfo: List<DataDiskStorageTypeInfoResponse>? = null,
    public val description: String? = null,
    public val id: String,
    public val isPlanAuthorized: Boolean? = null,
    public val location: String? = null,
    public val managedImageId: String? = null,
    public val managedSnapshotId: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
    public val vhd: CustomImagePropertiesCustomResponse? = null,
    public val vm: CustomImagePropertiesFromVmResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetCustomImageResult):
            GetCustomImageResult = GetCustomImageResult(
            author = javaType.author().map({ args0 -> args0 }).orElse(null),
            creationDate = javaType.creationDate(),
            customImagePlan = javaType.customImagePlan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.CustomImagePropertiesFromPlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataDiskStorageInfo = javaType.dataDiskStorageInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.DataDiskStorageTypeInfoResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isPlanAuthorized = javaType.isPlanAuthorized().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedImageId = javaType.managedImageId().map({ args0 -> args0 }).orElse(null),
            managedSnapshotId = javaType.managedSnapshotId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
            vhd = javaType.vhd().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.CustomImagePropertiesCustomResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vm = javaType.vm().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.CustomImagePropertiesFromVmResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
