@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A secret.
 * @property id The identifier of the resource.
 * @property location The location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 * @property value The value of the secret for secret creation.
 */
public data class GetSecretResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uniqueIdentifier: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.GetSecretResult):
            GetSecretResult = GetSecretResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uniqueIdentifier = javaType.uniqueIdentifier(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
