@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties of a network port.
 * @property backendPort Backend port of the target virtual machine.
 * @property transportProtocol Protocol type of the port.
 */
public data class PortResponse(
    public val backendPort: Int? = null,
    public val transportProtocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.PortResponse):
            PortResponse = PortResponse(
            backendPort = javaType.backendPort().map({ args0 -> args0 }).orElse(null),
            transportProtocol = javaType.transportProtocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
