@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Subnet information.
 * @property allowPublicIp The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
 * @property labSubnetName The name of the subnet as seen in the lab.
 * @property resourceId The resource ID of the subnet.
 */
public data class SubnetResponse(
    public val allowPublicIp: String? = null,
    public val labSubnetName: String? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.SubnetResponse):
            SubnetResponse = SubnetResponse(
            allowPublicIp = javaType.allowPublicIp().map({ args0 -> args0 }).orElse(null),
            labSubnetName = javaType.labSubnetName().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
