@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity attributes of a lab user.
 * @property appId Set to the app Id of the client JWT making the request.
 * @property objectId Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
 * @property principalId Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
 * @property principalName Set to the principal name / UPN of the client JWT making the request.
 * @property tenantId Set to the tenant ID of the client JWT making the request.
 */
public data class UserIdentityResponse(
    public val appId: String? = null,
    public val objectId: String? = null,
    public val principalId: String? = null,
    public val principalName: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.UserIdentityResponse):
            UserIdentityResponse = UserIdentityResponse(
            appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            principalName = javaType.principalName().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
