@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.inputs

import com.pulumi.azurenative.digitaltwins.inputs.ConnectionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a private endpoint connection.
 * @property groupIds The list of group ids for the private endpoint connection.
 * @property privateLinkServiceConnectionState The connection state.
 */
public data class ConnectionPropertiesArgs(
    public val groupIds: Output<List<String>>? = null,
    public val privateLinkServiceConnectionState:
    Output<ConnectionPropertiesPrivateLinkServiceConnectionStateArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.inputs.ConnectionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.inputs.ConnectionPropertiesArgs =
        com.pulumi.azurenative.digitaltwins.inputs.ConnectionPropertiesArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [ConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class ConnectionPropertiesArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var privateLinkServiceConnectionState:
        Output<ConnectionPropertiesPrivateLinkServiceConnectionStateArgs>? = null

    /**
     * @param value The list of group ids for the private endpoint connection.
     */
    @JvmName("bqtctdaobvgtufxh")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("wpadveswrxetbrai")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values The list of group ids for the private endpoint connection.
     */
    @JvmName("mntbvgvwkoxbnpnt")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The connection state.
     */
    @JvmName("ifrpfwlppupbokaj")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<ConnectionPropertiesPrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The list of group ids for the private endpoint connection.
     */
    @JvmName("cmofpvclhnxnwoux")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values The list of group ids for the private endpoint connection.
     */
    @JvmName("aklrtttvcqwnubew")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The connection state.
     */
    @JvmName("vhyckkfbetjvvrio")
    public suspend
    fun privateLinkServiceConnectionState(`value`: ConnectionPropertiesPrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument The connection state.
     */
    @JvmName("ibqmsrfhhhsikbsm")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend ConnectionPropertiesPrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectionPropertiesPrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    internal fun build(): ConnectionPropertiesArgs = ConnectionPropertiesArgs(
        groupIds = groupIds,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
    )
}
