@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.inputs

import com.pulumi.azurenative.digitaltwins.inputs.ConnectionPropertiesPrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.digitaltwins.kotlin.enums.PrivateLinkServiceConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The connection state.
 * @property actionsRequired Actions required for a private endpoint connection.
 * @property description The description for the current state of a private endpoint connection.
 * @property status The status of a private endpoint connection.
 */
public data class ConnectionPropertiesPrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>,
    public val status: Output<Either<String, PrivateLinkServiceConnectionStatus>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.digitaltwins.inputs.ConnectionPropertiesPrivateLinkServiceConnectionStateArgs> {
    override fun toJava():
        com.pulumi.azurenative.digitaltwins.inputs.ConnectionPropertiesPrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.digitaltwins.inputs.ConnectionPropertiesPrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description.applyValue({ args0 -> args0 }))
            .status(
                status.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionPropertiesPrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class ConnectionPropertiesPrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, PrivateLinkServiceConnectionStatus>>? = null

    /**
     * @param value Actions required for a private endpoint connection.
     */
    @JvmName("npsoviowainfawws")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value The description for the current state of a private endpoint connection.
     */
    @JvmName("xeracatcedvxsihl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The status of a private endpoint connection.
     */
    @JvmName("pmsiaxbrwwuowqjt")
    public suspend fun status(`value`: Output<Either<String, PrivateLinkServiceConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value Actions required for a private endpoint connection.
     */
    @JvmName("rcoxufxnyypqffqk")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value The description for the current state of a private endpoint connection.
     */
    @JvmName("xirqmktstmdkjnwc")
    public suspend fun description(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The status of a private endpoint connection.
     */
    @JvmName("ukdvksrxuhkdqrkh")
    public suspend fun status(`value`: Either<String, PrivateLinkServiceConnectionStatus>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of a private endpoint connection.
     */
    @JvmName("alqbxaiqrlwyniqy")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLinkServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of a private endpoint connection.
     */
    @JvmName("aabtawpmmuxahdvu")
    public fun status(`value`: PrivateLinkServiceConnectionStatus) {
        val toBeMapped = Either.ofRight<String, PrivateLinkServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ConnectionPropertiesPrivateLinkServiceConnectionStateArgs =
        ConnectionPropertiesPrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description ?: throw PulumiNullFieldException("description"),
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
