@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.inputs

import com.pulumi.azurenative.digitaltwins.inputs.ManagedIdentityReferenceArgs.builder
import com.pulumi.azurenative.digitaltwins.kotlin.enums.IdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the Managed Identity.
 * @property type The type of managed identity used.
 * @property userAssignedIdentity The user identity ARM resource id if the managed identity type is 'UserAssigned'.
 */
public data class ManagedIdentityReferenceArgs(
    public val type: Output<Either<String, IdentityType>>? = null,
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.inputs.ManagedIdentityReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.inputs.ManagedIdentityReferenceArgs =
        com.pulumi.azurenative.digitaltwins.inputs.ManagedIdentityReferenceArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedIdentityReferenceArgs].
 */
@PulumiTagMarker
public class ManagedIdentityReferenceArgsBuilder internal constructor() {
    private var type: Output<Either<String, IdentityType>>? = null

    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value The type of managed identity used.
     */
    @JvmName("hfcfylqjoslqxbuf")
    public suspend fun type(`value`: Output<Either<String, IdentityType>>) {
        this.type = value
    }

    /**
     * @param value The user identity ARM resource id if the managed identity type is 'UserAssigned'.
     */
    @JvmName("xnxeuslqrqchjixw")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The type of managed identity used.
     */
    @JvmName("ebtpyrnfogjnfnlj")
    public suspend fun type(`value`: Either<String, IdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of managed identity used.
     */
    @JvmName("frkigryhqjrxrywt")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of managed identity used.
     */
    @JvmName("ekruxfhojwohclxi")
    public fun type(`value`: IdentityType) {
        val toBeMapped = Either.ofRight<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user identity ARM resource id if the managed identity type is 'UserAssigned'.
     */
    @JvmName("obnxytgoakpittin")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): ManagedIdentityReferenceArgs = ManagedIdentityReferenceArgs(
        type = type,
        userAssignedIdentity = userAssignedIdentity,
    )
}
