@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.inputs

import com.pulumi.azurenative.digitaltwins.inputs.PrivateEndpointConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The private endpoint connection of a Digital Twin.
 * @property properties The connection properties.
 */
public data class PrivateEndpointConnectionArgs(
    public val properties: Output<ConnectionPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.inputs.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.inputs.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.digitaltwins.inputs.PrivateEndpointConnectionArgs.builder()
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var properties: Output<ConnectionPropertiesArgs>? = null

    /**
     * @param value The connection properties.
     */
    @JvmName("xuxxgstfpuwhgmog")
    public suspend fun properties(`value`: Output<ConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The connection properties.
     */
    @JvmName("pmyyukqewmpbxfjj")
    public suspend fun properties(`value`: ConnectionPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The connection properties.
     */
    @JvmName("usmqglygidsgryja")
    public suspend fun properties(argument: suspend ConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
