@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties related to EventGrid.
 * @property accessKey1 EventGrid secondary accesskey. Will be obfuscated during read.
 * @property accessKey2 EventGrid secondary accesskey. Will be obfuscated during read.
 * @property authenticationType Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
 * @property createdTime Time when the Endpoint was added to DigitalTwinsInstance.
 * @property deadLetterSecret Dead letter storage secret for key-based authentication. Will be obfuscated during read.
 * @property deadLetterUri Dead letter storage URL for identity-based authentication.
 * @property endpointType The type of Digital Twins endpoint
 * Expected value is 'EventGrid'.
 * @property identity Managed identity properties for the endpoint.
 * @property provisioningState The provisioning state.
 * @property topicEndpoint EventGrid Topic Endpoint.
 */
public data class EventGridResponse(
    public val accessKey1: String,
    public val accessKey2: String? = null,
    public val authenticationType: String? = null,
    public val createdTime: String,
    public val deadLetterSecret: String? = null,
    public val deadLetterUri: String? = null,
    public val endpointType: String,
    public val identity: ManagedIdentityReferenceResponse? = null,
    public val provisioningState: String,
    public val topicEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.EventGridResponse):
            EventGridResponse = EventGridResponse(
            accessKey1 = javaType.accessKey1(),
            accessKey2 = javaType.accessKey2().map({ args0 -> args0 }).orElse(null),
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime(),
            deadLetterSecret = javaType.deadLetterSecret().map({ args0 -> args0 }).orElse(null),
            deadLetterUri = javaType.deadLetterUri().map({ args0 -> args0 }).orElse(null),
            endpointType = javaType.endpointType(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.digitaltwins.kotlin.outputs.ManagedIdentityReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            topicEndpoint = javaType.topicEndpoint(),
        )
    }
}
