@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.CassandraClusterArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ClusterResourcePropertiesArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ClusterResourcePropertiesArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ManagedCassandraManagedServiceIdentityArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ManagedCassandraManagedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Representation of a managed Cassandra cluster.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-07-01-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBManagedCassandraClusterCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cassandraCluster = new AzureNative.DocumentDB.CassandraCluster("cassandraCluster", new()
 *     {
 *         ClusterName = "cassandra-prod",
 *         Location = "West US",
 *         Properties = new AzureNative.DocumentDB.Inputs.ClusterResourcePropertiesArgs
 *         {
 *             AuthenticationMethod = "Cassandra",
 *             CassandraVersion = "3.11",
 *             ClientCertificates = new[]
 *             {
 *                 new AzureNative.DocumentDB.Inputs.CertificateArgs
 *                 {
 *                     Pem = @"-----BEGIN CERTIFICATE-----
 * ...Base64 encoded certificate...
 * -----END CERTIFICATE-----",
 *                 },
 *             },
 *             ClusterNameOverride = "ClusterNameIllegalForAzureResource",
 *             DelegatedManagementSubnetId = "/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/management",
 *             ExternalGossipCertificates = new[]
 *             {
 *                 new AzureNative.DocumentDB.Inputs.CertificateArgs
 *                 {
 *                     Pem = @"-----BEGIN CERTIFICATE-----
 * ...Base64 encoded certificate...
 * -----END CERTIFICATE-----",
 *                 },
 *             },
 *             ExternalSeedNodes = new[]
 *             {
 *                 new AzureNative.DocumentDB.Inputs.SeedNodeArgs
 *                 {
 *                     IpAddress = "10.52.221.2",
 *                 },
 *                 new AzureNative.DocumentDB.Inputs.SeedNodeArgs
 *                 {
 *                     IpAddress = "10.52.221.3",
 *                 },
 *                 new AzureNative.DocumentDB.Inputs.SeedNodeArgs
 *                 {
 *                     IpAddress = "10.52.221.4",
 *                 },
 *             },
 *             HoursBetweenBackups = 24,
 *             InitialCassandraAdminPassword = "mypassword",
 *         },
 *         ResourceGroupName = "cassandra-prod-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewCassandraCluster(ctx, "cassandraCluster", &documentdb.CassandraClusterArgs{
 * 			ClusterName: pulumi.String("cassandra-prod"),
 * 			Location:    pulumi.String("West US"),
 * 			Properties: documentdb.ClusterResourceResponseProperties{
 * 				AuthenticationMethod: pulumi.String("Cassandra"),
 * 				CassandraVersion:     pulumi.String("3.11"),
 * 				ClientCertificates: documentdb.CertificateArray{
 * 					&documentdb.CertificateArgs{
 * 						Pem: pulumi.String("-----BEGIN CERTIFICATE-----\n...Base64 encoded certificate...\n-----END CERTIFICATE-----"),
 * 					},
 * 				},
 * 				ClusterNameOverride:         pulumi.String("ClusterNameIllegalForAzureResource"),
 * 				DelegatedManagementSubnetId: pulumi.String("/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/management"),
 * 				ExternalGossipCertificates: documentdb.CertificateArray{
 * 					&documentdb.CertificateArgs{
 * 						Pem: pulumi.String("-----BEGIN CERTIFICATE-----\n...Base64 encoded certificate...\n-----END CERTIFICATE-----"),
 * 					},
 * 				},
 * 				ExternalSeedNodes: documentdb.SeedNodeArray{
 * 					&documentdb.SeedNodeArgs{
 * 						IpAddress: pulumi.String("10.52.221.2"),
 * 					},
 * 					&documentdb.SeedNodeArgs{
 * 						IpAddress: pulumi.String("10.52.221.3"),
 * 					},
 * 					&documentdb.SeedNodeArgs{
 * 						IpAddress: pulumi.String("10.52.221.4"),
 * 					},
 * 				},
 * 				HoursBetweenBackups:           pulumi.Int(24),
 * 				InitialCassandraAdminPassword: pulumi.String("mypassword"),
 * 			},
 * 			ResourceGroupName: pulumi.String("cassandra-prod-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.CassandraCluster;
 * import com.pulumi.azurenative.documentdb.CassandraClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cassandraCluster = new CassandraCluster("cassandraCluster", CassandraClusterArgs.builder()
 *             .clusterName("cassandra-prod")
 *             .location("West US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationMethod", "Cassandra"),
 *                 Map.entry("cassandraVersion", "3.11"),
 *                 Map.entry("clientCertificates", Map.of("pem", """
 * -----BEGIN CERTIFICATE-----
 * ...Base64 encoded certificate...
 * -----END CERTIFICATE-----                """)),
 *                 Map.entry("clusterNameOverride", "ClusterNameIllegalForAzureResource"),
 *                 Map.entry("delegatedManagementSubnetId", "/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/management"),
 *                 Map.entry("externalGossipCertificates", Map.of("pem", """
 * -----BEGIN CERTIFICATE-----
 * ...Base64 encoded certificate...
 * -----END CERTIFICATE-----                """)),
 *                 Map.entry("externalSeedNodes",
 *                     Map.of("ipAddress", "10.52.221.2"),
 *                     Map.of("ipAddress", "10.52.221.3"),
 *                     Map.of("ipAddress", "10.52.221.4")),
 *                 Map.entry("hoursBetweenBackups", 24),
 *                 Map.entry("initialCassandraAdminPassword", "mypassword")
 *             ))
 *             .resourceGroupName("cassandra-prod-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:CassandraCluster cassandra-prod /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}
 * ```
 * @property clusterName Managed Cassandra cluster name.
 * @property identity Identity for the resource.
 * @property location The location of the resource group to which the resource belongs.
 * @property properties Properties of a managed Cassandra cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 */
public data class CassandraClusterArgs(
    public val clusterName: Output<String>? = null,
    public val identity: Output<ManagedCassandraManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ClusterResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.CassandraClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.CassandraClusterArgs =
        com.pulumi.azurenative.documentdb.CassandraClusterArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CassandraClusterArgs].
 */
@PulumiTagMarker
public class CassandraClusterArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var identity: Output<ManagedCassandraManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<ClusterResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Managed Cassandra cluster name.
     */
    @JvmName("tofkaqixqsojmfxb")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("gocqwwpqwcxhsphl")
    public suspend fun identity(`value`: Output<ManagedCassandraManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("gawghndiecxrcsfs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of a managed Cassandra cluster.
     */
    @JvmName("slqdctvwednnqqjv")
    public suspend fun properties(`value`: Output<ClusterResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("drcnuqajgjrnekcf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("rmxidlecyuuofubq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Managed Cassandra cluster name.
     */
    @JvmName("sjdykseobawmtmgx")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("csjwauscwpbfsjxw")
    public suspend fun identity(`value`: ManagedCassandraManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("jsonxdxffrijoigq")
    public suspend
    fun identity(argument: suspend ManagedCassandraManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedCassandraManagedServiceIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("omvcijxadgkbcfwb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of a managed Cassandra cluster.
     */
    @JvmName("mgwtuyporadmxlpd")
    public suspend fun properties(`value`: ClusterResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of a managed Cassandra cluster.
     */
    @JvmName("qvrjxnukypoxjywp")
    public suspend fun properties(argument: suspend ClusterResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pwguxkrlsuxaybup")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("kxyvljoemcecpynm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("aeuqivcowlhrjach")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CassandraClusterArgs = CassandraClusterArgs(
        clusterName = clusterName,
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
