@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.GremlinGraphGetPropertiesResponseOptions
import com.pulumi.azurenative.documentdb.kotlin.outputs.GremlinGraphGetPropertiesResponseResource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.GremlinGraphGetPropertiesResponseOptions.Companion.toKotlin as gremlinGraphGetPropertiesResponseOptionsToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.GremlinGraphGetPropertiesResponseResource.Companion.toKotlin as gremlinGraphGetPropertiesResponseResourceToKotlin

/**
 * Builder for [GremlinResourceGremlinGraph].
 */
@PulumiTagMarker
public class GremlinResourceGremlinGraphResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GremlinResourceGremlinGraphArgs = GremlinResourceGremlinGraphArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GremlinResourceGremlinGraphArgsBuilder.() -> Unit) {
        val builder = GremlinResourceGremlinGraphArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GremlinResourceGremlinGraph {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraph(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GremlinResourceGremlinGraph(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB Gremlin graph.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBGremlinGraphCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gremlinResourceGremlinGraph = new AzureNative.DocumentDB.GremlinResourceGremlinGraph("gremlinResourceGremlinGraph", new()
 *     {
 *         AccountName = "ddb1",
 *         DatabaseName = "databaseName",
 *         GraphName = "graphName",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.GremlinGraphResourceArgs
 *         {
 *             ConflictResolutionPolicy = new AzureNative.DocumentDB.Inputs.ConflictResolutionPolicyArgs
 *             {
 *                 ConflictResolutionPath = "/path",
 *                 Mode = "LastWriterWins",
 *             },
 *             DefaultTtl = 100,
 *             Id = "graphName",
 *             IndexingPolicy = new AzureNative.DocumentDB.Inputs.IndexingPolicyArgs
 *             {
 *                 Automatic = true,
 *                 ExcludedPaths = new[] {},
 *                 IncludedPaths = new[]
 *                 {
 *                     new AzureNative.DocumentDB.Inputs.IncludedPathArgs
 *                     {
 *                         Indexes = new[]
 *                         {
 *                             new AzureNative.DocumentDB.Inputs.IndexesArgs
 *                             {
 *                                 DataType = "String",
 *                                 Kind = "Range",
 *                                 Precision = -1,
 *                             },
 *                             new AzureNative.DocumentDB.Inputs.IndexesArgs
 *                             {
 *                                 DataType = "Number",
 *                                 Kind = "Range",
 *                                 Precision = -1,
 *                             },
 *                         },
 *                         Path = "/*",
 *                     },
 *                 },
 *                 IndexingMode = "consistent",
 *             },
 *             PartitionKey = new AzureNative.DocumentDB.Inputs.ContainerPartitionKeyArgs
 *             {
 *                 Kind = "Hash",
 *                 Paths = new[]
 *                 {
 *                     "/AccountNumber",
 *                 },
 *             },
 *             UniqueKeyPolicy = new AzureNative.DocumentDB.Inputs.UniqueKeyPolicyArgs
 *             {
 *                 UniqueKeys = new[]
 *                 {
 *                     new AzureNative.DocumentDB.Inputs.UniqueKeyArgs
 *                     {
 *                         Paths = new[]
 *                         {
 *                             "/testPath",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := documentdb.NewGremlinResourceGremlinGraph(ctx, "gremlinResourceGremlinGraph", &documentdb.GremlinResourceGremlinGraphArgs{
 * AccountName: pulumi.String("ddb1"),
 * DatabaseName: pulumi.String("databaseName"),
 * GraphName: pulumi.String("graphName"),
 * Location: pulumi.String("West US"),
 * Options: nil,
 * Resource: documentdb.GremlinGraphGetPropertiesResponseResource{
 * ConflictResolutionPolicy: &documentdb.ConflictResolutionPolicyArgs{
 * ConflictResolutionPath: pulumi.String("/path"),
 * Mode: pulumi.String("LastWriterWins"),
 * },
 * DefaultTtl: pulumi.Int(100),
 * Id: pulumi.String("graphName"),
 * IndexingPolicy: interface{}{
 * Automatic: pulumi.Bool(true),
 * ExcludedPaths: documentdb.ExcludedPathArray{
 * },
 * IncludedPaths: documentdb.IncludedPathArray{
 * interface{}{
 * Indexes: documentdb.IndexesArray{
 * &documentdb.IndexesArgs{
 * DataType: pulumi.String("String"),
 * Kind: pulumi.String("Range"),
 * Precision: -1,
 * },
 * &documentdb.IndexesArgs{
 * DataType: pulumi.String("Number"),
 * Kind: pulumi.String("Range"),
 * Precision: -1,
 * },
 * },
 * Path: pulumi.String("/*"),
 * },
 * },
 * IndexingMode: pulumi.String("consistent"),
 * },
 * PartitionKey: &documentdb.ContainerPartitionKeyArgs{
 * Kind: pulumi.String("Hash"),
 * Paths: pulumi.StringArray{
 * pulumi.String("/AccountNumber"),
 * },
 * },
 * UniqueKeyPolicy: interface{}{
 * UniqueKeys: documentdb.UniqueKeyArray{
 * &documentdb.UniqueKeyArgs{
 * Paths: pulumi.StringArray{
 * pulumi.String("/testPath"),
 * },
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraph;
 * import com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraphArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gremlinResourceGremlinGraph = new GremlinResourceGremlinGraph("gremlinResourceGremlinGraph", GremlinResourceGremlinGraphArgs.builder()
 *             .accountName("ddb1")
 *             .databaseName("databaseName")
 *             .graphName("graphName")
 *             .location("West US")
 *             .options()
 *             .resource(Map.ofEntries(
 *                 Map.entry("conflictResolutionPolicy", Map.ofEntries(
 *                     Map.entry("conflictResolutionPath", "/path"),
 *                     Map.entry("mode", "LastWriterWins")
 *                 )),
 *                 Map.entry("defaultTtl", 100),
 *                 Map.entry("id", "graphName"),
 *                 Map.entry("indexingPolicy", Map.ofEntries(
 *                     Map.entry("automatic", true),
 *                     Map.entry("excludedPaths", ),
 *                     Map.entry("includedPaths", Map.ofEntries(
 *                         Map.entry("indexes",
 *                             Map.ofEntries(
 *                                 Map.entry("dataType", "String"),
 *                                 Map.entry("kind", "Range"),
 *                                 Map.entry("precision", "TODO: GenUnaryOpExpression")
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("dataType", "Number"),
 *                                 Map.entry("kind", "Range"),
 *                                 Map.entry("precision", "TODO: GenUnaryOpExpression")
 *                             )),
 *                         Map.entry("path", "/*")
 *                     )),
 *                     Map.entry("indexingMode", "consistent")
 *                 )),
 *                 Map.entry("partitionKey", Map.ofEntries(
 *                     Map.entry("kind", "Hash"),
 *                     Map.entry("paths", "/AccountNumber")
 *                 )),
 *                 Map.entry("uniqueKeyPolicy", Map.of("uniqueKeys", Map.of("paths", "/testPath")))
 *             ))
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:GremlinResourceGremlinGraph graphName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}
 * ```
 * */*/*/
 */
public class GremlinResourceGremlinGraph internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraph,
) : KotlinCustomResource(javaResource, GremlinResourceGremlinGraphMapper) {
    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val options: Output<GremlinGraphGetPropertiesResponseOptions>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    gremlinGraphGetPropertiesResponseOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val resource: Output<GremlinGraphGetPropertiesResponseResource>?
        get() = javaResource.resource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    gremlinGraphGetPropertiesResponseResourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GremlinResourceGremlinGraphMapper : ResourceMapper<GremlinResourceGremlinGraph> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraph::class == javaResource::class

    override fun map(javaResource: Resource): GremlinResourceGremlinGraph =
        GremlinResourceGremlinGraph(
            javaResource as
                com.pulumi.azurenative.documentdb.GremlinResourceGremlinGraph,
        )
}

/**
 * @see [GremlinResourceGremlinGraph].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GremlinResourceGremlinGraph].
 */
public suspend fun gremlinResourceGremlinGraph(
    name: String,
    block: suspend GremlinResourceGremlinGraphResourceBuilder.() -> Unit,
):
    GremlinResourceGremlinGraph {
    val builder = GremlinResourceGremlinGraphResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GremlinResourceGremlinGraph].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gremlinResourceGremlinGraph(name: String): GremlinResourceGremlinGraph {
    val builder = GremlinResourceGremlinGraphResourceBuilder()
    builder.name(name)
    return builder.build()
}
