@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.MongoDBCollectionGetPropertiesResponseOptions
import com.pulumi.azurenative.documentdb.kotlin.outputs.MongoDBCollectionGetPropertiesResponseResource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.MongoDBCollectionGetPropertiesResponseOptions.Companion.toKotlin as mongoDBCollectionGetPropertiesResponseOptionsToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.MongoDBCollectionGetPropertiesResponseResource.Companion.toKotlin as mongoDBCollectionGetPropertiesResponseResourceToKotlin

/**
 * Builder for [MongoDBResourceMongoDBCollection].
 */
@PulumiTagMarker
public class MongoDBResourceMongoDBCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MongoDBResourceMongoDBCollectionArgs = MongoDBResourceMongoDBCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MongoDBResourceMongoDBCollectionArgsBuilder.() -> Unit) {
        val builder = MongoDBResourceMongoDBCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MongoDBResourceMongoDBCollection {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MongoDBResourceMongoDBCollection(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB MongoDB collection.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBMongoDBCollectionCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongoDBResourceMongoDBCollection = new AzureNative.DocumentDB.MongoDBResourceMongoDBCollection("mongoDBResourceMongoDBCollection", new()
 *     {
 *         AccountName = "ddb1",
 *         CollectionName = "collectionName",
 *         DatabaseName = "databaseName",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.MongoDBCollectionResourceArgs
 *         {
 *             Id = "collectionName",
 *             Indexes = new[]
 *             {
 *                 new AzureNative.DocumentDB.Inputs.MongoIndexArgs
 *                 {
 *                     Key = new AzureNative.DocumentDB.Inputs.MongoIndexKeysArgs
 *                     {
 *                         Keys = new[]
 *                         {
 *                             "_ts",
 *                         },
 *                     },
 *                     Options = new AzureNative.DocumentDB.Inputs.MongoIndexOptionsArgs
 *                     {
 *                         ExpireAfterSeconds = 100,
 *                         Unique = true,
 *                     },
 *                 },
 *                 new AzureNative.DocumentDB.Inputs.MongoIndexArgs
 *                 {
 *                     Key = new AzureNative.DocumentDB.Inputs.MongoIndexKeysArgs
 *                     {
 *                         Keys = new[]
 *                         {
 *                             "_id",
 *                         },
 *                     },
 *                 },
 *             },
 *             ShardKey =
 *             {
 *                 { "testKey", "Hash" },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := documentdb.NewMongoDBResourceMongoDBCollection(ctx, "mongoDBResourceMongoDBCollection", &documentdb.MongoDBResourceMongoDBCollectionArgs{
 * AccountName: pulumi.String("ddb1"),
 * CollectionName: pulumi.String("collectionName"),
 * DatabaseName: pulumi.String("databaseName"),
 * Location: pulumi.String("West US"),
 * Options: nil,
 * Resource: documentdb.MongoDBCollectionGetPropertiesResponseResource{
 * Id: pulumi.String("collectionName"),
 * Indexes: documentdb.MongoIndexArray{
 * interface{}{
 * Key: &documentdb.MongoIndexKeysArgs{
 * Keys: pulumi.StringArray{
 * pulumi.String("_ts"),
 * },
 * },
 * Options: &documentdb.MongoIndexOptionsArgs{
 * ExpireAfterSeconds: pulumi.Int(100),
 * Unique: pulumi.Bool(true),
 * },
 * },
 * interface{}{
 * Key: &documentdb.MongoIndexKeysArgs{
 * Keys: pulumi.StringArray{
 * pulumi.String("_id"),
 * },
 * },
 * },
 * },
 * ShardKey: pulumi.StringMap{
 * "testKey": pulumi.String("Hash"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollection;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongoDBResourceMongoDBCollection = new MongoDBResourceMongoDBCollection("mongoDBResourceMongoDBCollection", MongoDBResourceMongoDBCollectionArgs.builder()
 *             .accountName("ddb1")
 *             .collectionName("collectionName")
 *             .databaseName("databaseName")
 *             .location("West US")
 *             .options()
 *             .resource(Map.ofEntries(
 *                 Map.entry("id", "collectionName"),
 *                 Map.entry("indexes",
 *                     Map.ofEntries(
 *                         Map.entry("key", Map.of("keys", "_ts")),
 *                         Map.entry("options", Map.ofEntries(
 *                             Map.entry("expireAfterSeconds", 100),
 *                             Map.entry("unique", true)
 *                         ))
 *                     ),
 *                     Map.of("key", Map.of("keys", "_id"))),
 *                 Map.entry("shardKey", Map.of("testKey", "Hash"))
 *             ))
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:MongoDBResourceMongoDBCollection collectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}
 * ```
 */
public class MongoDBResourceMongoDBCollection internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollection,
) : KotlinCustomResource(javaResource, MongoDBResourceMongoDBCollectionMapper) {
    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val options: Output<MongoDBCollectionGetPropertiesResponseOptions>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    mongoDBCollectionGetPropertiesResponseOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val resource: Output<MongoDBCollectionGetPropertiesResponseResource>?
        get() = javaResource.resource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    mongoDBCollectionGetPropertiesResponseResourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MongoDBResourceMongoDBCollectionMapper :
    ResourceMapper<MongoDBResourceMongoDBCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollection::class == javaResource::class

    override fun map(javaResource: Resource): MongoDBResourceMongoDBCollection =
        MongoDBResourceMongoDBCollection(
            javaResource as
                com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollection,
        )
}

/**
 * @see [MongoDBResourceMongoDBCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MongoDBResourceMongoDBCollection].
 */
public suspend fun mongoDBResourceMongoDBCollection(
    name: String,
    block: suspend MongoDBResourceMongoDBCollectionResourceBuilder.() -> Unit,
):
    MongoDBResourceMongoDBCollection {
    val builder = MongoDBResourceMongoDBCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MongoDBResourceMongoDBCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mongoDBResourceMongoDBCollection(name: String): MongoDBResourceMongoDBCollection {
    val builder = MongoDBResourceMongoDBCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
