@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollectionArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.MongoDBCollectionResourceArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.MongoDBCollectionResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB MongoDB collection.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBMongoDBCollectionCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongoDBResourceMongoDBCollection = new AzureNative.DocumentDB.MongoDBResourceMongoDBCollection("mongoDBResourceMongoDBCollection", new()
 *     {
 *         AccountName = "ddb1",
 *         CollectionName = "collectionName",
 *         DatabaseName = "databaseName",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.MongoDBCollectionResourceArgs
 *         {
 *             Id = "collectionName",
 *             Indexes = new[]
 *             {
 *                 new AzureNative.DocumentDB.Inputs.MongoIndexArgs
 *                 {
 *                     Key = new AzureNative.DocumentDB.Inputs.MongoIndexKeysArgs
 *                     {
 *                         Keys = new[]
 *                         {
 *                             "_ts",
 *                         },
 *                     },
 *                     Options = new AzureNative.DocumentDB.Inputs.MongoIndexOptionsArgs
 *                     {
 *                         ExpireAfterSeconds = 100,
 *                         Unique = true,
 *                     },
 *                 },
 *                 new AzureNative.DocumentDB.Inputs.MongoIndexArgs
 *                 {
 *                     Key = new AzureNative.DocumentDB.Inputs.MongoIndexKeysArgs
 *                     {
 *                         Keys = new[]
 *                         {
 *                             "_id",
 *                         },
 *                     },
 *                 },
 *             },
 *             ShardKey =
 *             {
 *                 { "testKey", "Hash" },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := documentdb.NewMongoDBResourceMongoDBCollection(ctx, "mongoDBResourceMongoDBCollection", &documentdb.MongoDBResourceMongoDBCollectionArgs{
 * AccountName: pulumi.String("ddb1"),
 * CollectionName: pulumi.String("collectionName"),
 * DatabaseName: pulumi.String("databaseName"),
 * Location: pulumi.String("West US"),
 * Options: nil,
 * Resource: documentdb.MongoDBCollectionGetPropertiesResponseResource{
 * Id: pulumi.String("collectionName"),
 * Indexes: documentdb.MongoIndexArray{
 * interface{}{
 * Key: &documentdb.MongoIndexKeysArgs{
 * Keys: pulumi.StringArray{
 * pulumi.String("_ts"),
 * },
 * },
 * Options: &documentdb.MongoIndexOptionsArgs{
 * ExpireAfterSeconds: pulumi.Int(100),
 * Unique: pulumi.Bool(true),
 * },
 * },
 * interface{}{
 * Key: &documentdb.MongoIndexKeysArgs{
 * Keys: pulumi.StringArray{
 * pulumi.String("_id"),
 * },
 * },
 * },
 * },
 * ShardKey: pulumi.StringMap{
 * "testKey": pulumi.String("Hash"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollection;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongoDBResourceMongoDBCollection = new MongoDBResourceMongoDBCollection("mongoDBResourceMongoDBCollection", MongoDBResourceMongoDBCollectionArgs.builder()
 *             .accountName("ddb1")
 *             .collectionName("collectionName")
 *             .databaseName("databaseName")
 *             .location("West US")
 *             .options()
 *             .resource(Map.ofEntries(
 *                 Map.entry("id", "collectionName"),
 *                 Map.entry("indexes",
 *                     Map.ofEntries(
 *                         Map.entry("key", Map.of("keys", "_ts")),
 *                         Map.entry("options", Map.ofEntries(
 *                             Map.entry("expireAfterSeconds", 100),
 *                             Map.entry("unique", true)
 *                         ))
 *                     ),
 *                     Map.of("key", Map.of("keys", "_id"))),
 *                 Map.entry("shardKey", Map.of("testKey", "Hash"))
 *             ))
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:MongoDBResourceMongoDBCollection collectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property collectionName Cosmos DB collection name.
 * @property databaseName Cosmos DB database name.
 * @property location The location of the resource group to which the resource belongs.
 * @property options A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
 * @property resource The standard JSON format of a MongoDB collection
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 */
public data class MongoDBResourceMongoDBCollectionArgs(
    public val accountName: Output<String>? = null,
    public val collectionName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val options: Output<CreateUpdateOptionsArgs>? = null,
    public val resource: Output<MongoDBCollectionResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollectionArgs =
        com.pulumi.azurenative.documentdb.MongoDBResourceMongoDBCollectionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .collectionName(collectionName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MongoDBResourceMongoDBCollectionArgs].
 */
@PulumiTagMarker
public class MongoDBResourceMongoDBCollectionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var collectionName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var location: Output<String>? = null

    private var options: Output<CreateUpdateOptionsArgs>? = null

    private var resource: Output<MongoDBCollectionResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("wadbincqrbpsfwfl")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Cosmos DB collection name.
     */
    @JvmName("regktgqrydnqxfhv")
    public suspend fun collectionName(`value`: Output<String>) {
        this.collectionName = value
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("dpqntteeefufggbn")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("romeepttcynabgql")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("qvfscubejdbrobie")
    public suspend fun options(`value`: Output<CreateUpdateOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value The standard JSON format of a MongoDB collection
     */
    @JvmName("bpokwhuuqghsigpq")
    public suspend fun resource(`value`: Output<MongoDBCollectionResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iivoogaagbvixrlt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("dqjqkdxejnumdyly")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("vqkshfbkaeutcwui")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB collection name.
     */
    @JvmName("wdpjkfgfjlbvaxwn")
    public suspend fun collectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("iangqglaokveynpd")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("qrpfcsemvepggreh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("bjalhsffydeevxpb")
    public suspend fun options(`value`: CreateUpdateOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("bpkqoqulbvsbyotd")
    public suspend fun options(argument: suspend CreateUpdateOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = CreateUpdateOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value The standard JSON format of a MongoDB collection
     */
    @JvmName("qmhumsrqflijjaow")
    public suspend fun resource(`value`: MongoDBCollectionResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument The standard JSON format of a MongoDB collection
     */
    @JvmName("raiyugqtntpmlqds")
    public suspend fun resource(argument: suspend MongoDBCollectionResourceArgsBuilder.() -> Unit) {
        val toBeMapped = MongoDBCollectionResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("phxnwbxakbxkqojg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("dxfmylojaqdseugh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("niyvypxjcywcnlhl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MongoDBResourceMongoDBCollectionArgs = MongoDBResourceMongoDBCollectionArgs(
        accountName = accountName,
        collectionName = collectionName,
        databaseName = databaseName,
        location = location,
        options = options,
        resource = resource,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
